"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MVTSingleLayerVectorSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _mvt_single_layer_source_settings = require("./mvt_single_layer_source_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MVTSingleLayerVectorSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      urlTemplate: '',
      layerName: '',
      minSourceZoom: _constants.MIN_ZOOM,
      maxSourceZoom: _constants.MAX_ZOOM,
      fields: []
    });
    (0, _defineProperty2.default)(this, "_sourceConfigChange", _lodash.default.debounce(() => {
      const canPreview = this.state.urlTemplate.indexOf('{x}') >= 0 && this.state.urlTemplate.indexOf('{y}') >= 0 && this.state.urlTemplate.indexOf('{z}') >= 0;
      if (canPreview && this.state.layerName) {
        this.props.onSourceConfigChange({
          urlTemplate: this.state.urlTemplate,
          layerName: this.state.layerName,
          minSourceZoom: this.state.minSourceZoom,
          maxSourceZoom: this.state.maxSourceZoom,
          fields: this.state.fields
        });
      }
    }, 200));
    (0, _defineProperty2.default)(this, "_handleUrlTemplateChange", e => {
      const url = e.target.value;
      this.setState({
        urlTemplate: url
      }, () => this._sourceConfigChange());
    });
    (0, _defineProperty2.default)(this, "_handleChange", state => {
      this.setState(state, () => this._sourceConfigChange());
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.urlMessage', {
        defaultMessage: 'Url'
      }),
      helpText: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.urlHelpMessage', {
        defaultMessage: 'URL of the .mvt vector tile service. e.g. {url}',
        values: {
          url: 'http://company.com/{z}/{x}/{y}.pbf'
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.urlTemplate,
      onChange: this._handleUrlTemplateChange,
      compressed: true
    })), /*#__PURE__*/_react.default.createElement(_mvt_single_layer_source_settings.MVTSingleLayerSourceSettings, {
      handleChange: this._handleChange,
      layerName: this.state.layerName,
      fields: this.state.fields,
      minSourceZoom: this.state.minSourceZoom,
      maxSourceZoom: this.state.maxSourceZoom,
      showFields: false
    }));
  }
}
exports.MVTSingleLayerVectorSourceEditor = MVTSingleLayerVectorSourceEditor;