"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceTitle = exports.MVTSingleLayerVectorSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _react = _interopRequireDefault(require("react"));
var _source = require("../source");
var _constants = require("../../../../common/constants");
var _i18n_getters = require("../../../../common/i18n_getters");
var _mvt_field = require("../../fields/mvt_field");
var _update_source_editor = require("./update_source_editor");
var _tooltip_property = require("../../tooltips/tooltip_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourceTitle = _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSource.sourceTitle', {
  defaultMessage: 'Vector tiles'
});
exports.sourceTitle = sourceTitle;
class MVTSingleLayerVectorSource extends _source.AbstractSource {
  static createDescriptor({
    urlTemplate,
    layerName,
    minSourceZoom,
    maxSourceZoom,
    fields,
    tooltipProperties
  }) {
    return {
      type: _constants.SOURCE_TYPES.MVT_SINGLE_LAYER,
      id: (0, _uuid.v4)(),
      urlTemplate: urlTemplate ? urlTemplate : '',
      layerName: layerName ? layerName : '',
      minSourceZoom: typeof minSourceZoom === 'number' ? Math.max(_constants.MIN_ZOOM, minSourceZoom) : _constants.MIN_ZOOM,
      maxSourceZoom: typeof maxSourceZoom === 'number' ? Math.min(_constants.MAX_ZOOM, maxSourceZoom) : _constants.MAX_ZOOM,
      fields: fields ? fields : [],
      tooltipProperties: tooltipProperties ? tooltipProperties : []
    };
  }
  constructor(sourceDescriptor) {
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    (0, _defineProperty2.default)(this, "_tooltipFields", void 0);
    this._descriptor = MVTSingleLayerVectorSource.createDescriptor(sourceDescriptor);
    this._tooltipFields = this._descriptor.tooltipProperties.map(fieldName => {
      return this.getFieldByName(fieldName);
    }).filter(f => f !== null);
  }
  isMvt() {
    return true;
  }
  async supportsFitToBounds() {
    return false;
  }
  renderSourceSettingsEditor({
    onChange
  }) {
    return /*#__PURE__*/_react.default.createElement(_update_source_editor.UpdateSourceEditor, {
      onChange: onChange,
      tooltipFields: this._tooltipFields,
      source: this
    });
  }
  getFieldNames() {
    return this._descriptor.fields.map(field => {
      return field.name;
    });
  }
  addFeature(geometry) {
    throw new Error('Does not implement addFeature');
  }
  deleteFeature(featureId) {
    throw new Error('Does not implement deleteFeature');
  }
  getMVTFields() {
    return this._descriptor.fields.map(field => {
      return new _mvt_field.MVTField({
        fieldName: field.name,
        type: field.type,
        source: this,
        origin: _constants.FIELD_ORIGIN.SOURCE
      });
    });
  }
  getFieldByName(fieldName) {
    try {
      return this.createField({
        fieldName
      });
    } catch (e) {
      return null;
    }
  }
  createField({
    fieldName
  }) {
    const field = this._descriptor.fields.find(f => {
      return f.name === fieldName;
    });
    if (!field) {
      throw new Error(`Cannot create field for fieldName ${fieldName}`);
    }
    return new _mvt_field.MVTField({
      fieldName: field.name,
      type: field.type,
      source: this,
      origin: _constants.FIELD_ORIGIN.SOURCE
    });
  }
  getGeoJsonWithMeta() {
    // Having this method here is a consequence of IMvtVectorSource extending IVectorSource.
    throw new Error('Does not implement getGeoJsonWithMeta');
  }
  async getFields() {
    return this.getMVTFields();
  }
  getTileSourceLayer() {
    return this._descriptor.layerName;
  }
  async getImmutableProperties() {
    return [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: sourceTitle
    }, {
      label: (0, _i18n_getters.getUrlLabel)(),
      value: this._descriptor.urlTemplate
    }];
  }
  async getDisplayName() {
    return this.getTileSourceLayer();
  }
  async getTileUrl() {
    return this._descriptor.urlTemplate;
  }
  async getSupportedShapeTypes() {
    return [_constants.VECTOR_SHAPE_TYPE.POINT, _constants.VECTOR_SHAPE_TYPE.LINE, _constants.VECTOR_SHAPE_TYPE.POLYGON];
  }
  hasTooltipProperties() {
    return !!this._tooltipFields.length;
  }
  getMinZoom() {
    return this._descriptor.minSourceZoom;
  }
  getMaxZoom() {
    return this._descriptor.maxSourceZoom;
  }
  async getBoundsForFilters(boundsFilters, registerCancelCallback) {
    return null;
  }
  getSyncMeta() {
    return null;
  }
  isBoundsAware() {
    return false;
  }
  getSourceStatus() {
    return {
      tooltipContent: null,
      areResultsTrimmed: false
    };
  }
  async getLeftJoinFields() {
    return [];
  }
  async getTooltipProperties(properties) {
    const tooltips = [];
    for (const key in properties) {
      if (properties.hasOwnProperty(key)) {
        for (let i = 0; i < this._tooltipFields.length; i++) {
          const mvtField = this._tooltipFields[i];
          if (mvtField.getName() === key) {
            const tooltip = new _tooltip_property.TooltipProperty(key, key, properties[key]);
            tooltips.push(tooltip);
            break;
          }
        }
      }
    }
    return tooltips;
  }
  async getTimesliceMaskFieldName() {
    return null;
  }
  async supportsFeatureEditing() {
    return false;
  }
  async getDefaultFields() {
    return {};
  }
  showJoinEditor() {
    return false;
  }
  getJoinsDisabledReason() {
    return null;
  }
  getFeatureActions(args) {
    // Its not possible to filter by geometry for vector tile sources since there is no way to get original geometry
    return [];
  }
}
exports.MVTSingleLayerVectorSource = MVTSingleLayerVectorSource;