"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScalingDocumenationPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ScalingDocumenationPopover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  _renderContent() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      style: {
        maxWidth: '36em'
      }
    }, /*#__PURE__*/_react.default.createElement("dl", null, /*#__PURE__*/_react.default.createElement("dt", null, this.props.mvtOptionLabel, " (Default)"), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.mvtDetails",
      defaultMessage: "Vector tiles partition your map into tiles, with each tile displaying features from the first {maxResultWindow} documents. Results exceeding {maxResultWindow} are not displayed in a tile. A bounding box indicates the area where data is incomplete.",
      values: {
        maxResultWindow: this.props.maxResultWindow
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.mvtUseCase",
      defaultMessage: "Use this option to display large data sets with the fastest loading times."
    }))), /*#__PURE__*/_react.default.createElement("dt", null, this.props.clustersOptionLabel), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.clustersDetails",
      defaultMessage: "Display clusters when results exceed {maxResultWindow} documents. Display documents when results are less then {maxResultWindow}.",
      values: {
        maxResultWindow: this.props.maxResultWindow
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.clustersUseCase",
      defaultMessage: "Use this option to display large data sets. Does not support term joins."
    }))), /*#__PURE__*/_react.default.createElement("dt", null, this.props.limitOptionLabel), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.limitDetails",
      defaultMessage: "Display features from the first {maxResultWindow} documents.",
      values: {
        maxResultWindow: this.props.maxResultWindow
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.limitUseCases",
      defaultMessage: "Use this option when you can not use vector tiles for the following reasons:"
    }), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.limitUseCase.formatLabels",
      defaultMessage: "Formatted labels"
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.limitUseCase.multipleJoins",
      defaultMessage: "Multiple term joins"
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.limitUseCase.joinFieldsWithLayoutStyles",
      defaultMessage: "Data driven styling from term join metrics with 'Label', 'Label size', icon 'Symbol size', and 'Symbol orientation' style properties"
    })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.limitUseCase.scriptedFields",
      defaultMessage: "Data driven styling from scripted fields"
    })))))), /*#__PURE__*/_react.default.createElement("p", {
      style: {
        fontStyle: 'italic'
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.scalingDocs.maxResultWindow",
      defaultMessage: "{maxResultWindow} constraint provided by {link} index setting.",
      values: {
        maxResultWindow: this.props.maxResultWindow,
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _kibana_services.getDocLinks)().links.elasticsearch.dynamicIndexSettings,
          target: "_blank",
          external: true
        }, "max_result_window")
      }
    }))));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "scalingHelpPopover",
      anchorPosition: "leftCenter",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: this._togglePopover,
        iconType: "documentation",
        "aria-label": "Scaling documentation"
      }),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      repositionOnScroll: true,
      ownFocus: true
    }, this._renderContent());
  }
}
exports.ScalingDocumenationPopover = ScalingDocumenationPopover;