"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMatchingIndexes = exports.getIsDrawLayer = exports.deleteFeatureFromIndex = exports.addFeatureToIndex = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _constants = require("../../../../../common/constants");
var _kibana_services = require("../../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addFeatureToIndex = async (indexName, geometry, path, defaultFields) => {
  const data = (0, _saferLodashSet.set)({
    ...defaultFields
  }, path, geometry);
  return await (0, _kibana_services.getHttp)().fetch({
    path: `${_constants.INDEX_FEATURE_PATH}`,
    method: 'POST',
    body: JSON.stringify({
      index: indexName,
      data
    })
  });
};
exports.addFeatureToIndex = addFeatureToIndex;
const deleteFeatureFromIndex = async (indexName, featureId) => {
  return await (0, _kibana_services.getHttp)().fetch({
    path: `${_constants.INDEX_FEATURE_PATH}/${featureId}`,
    method: 'DELETE',
    body: JSON.stringify({
      index: indexName
    })
  });
};
exports.deleteFeatureFromIndex = deleteFeatureFromIndex;
const getMatchingIndexes = async indexPattern => {
  return await (0, _kibana_services.getHttp)().fetch({
    path: _constants.GET_MATCHING_INDEXES_PATH,
    method: 'GET',
    query: {
      indexPattern
    }
  });
};
exports.getMatchingIndexes = getMatchingIndexes;
const getIsDrawLayer = async index => {
  return await (0, _kibana_services.getHttp)().fetch({
    path: _constants.CHECK_IS_DRAWING_INDEX,
    method: 'GET',
    query: {
      index
    }
  });
};
exports.getIsDrawLayer = getIsDrawLayer;