"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopHitsForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _single_field_select = require("../../../../components/single_field_select");
var _kibana_services = require("../../../../kibana_services");
var _validated_range = require("../../../../components/validated_range");
var _constants = require("../../../../../common/constants");
var _load_index_settings = require("../util/load_index_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TopHitsForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      maxInnerResultWindow: _constants.DEFAULT_MAX_INNER_RESULT_WINDOW
    });
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onTopHitsSplitFieldChange", topHitsSplitField => {
      if (!topHitsSplitField) {
        return;
      }
      this.props.onChange({
        propName: 'topHitsSplitField',
        value: topHitsSplitField
      });
    });
    (0, _defineProperty2.default)(this, "_onTopHitsSizeChange", size => {
      this.props.onChange({
        propName: 'topHitsSize',
        value: size
      });
    });
    (0, _defineProperty2.default)(this, "_onSortFieldChange", sortField => {
      this.props.onChange({
        propName: 'sortField',
        value: sortField
      });
    });
    (0, _defineProperty2.default)(this, "_onSortOrderChange", event => {
      this.props.onChange({
        propName: 'sortOrder',
        value: event.target.value
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.loadIndexSettings();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async loadIndexSettings() {
    try {
      const dataView = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
      const {
        maxInnerResultWindow
      } = await (0, _load_index_settings.loadIndexSettings)(dataView.getIndexPattern());
      if (this._isMounted) {
        this.setState({
          maxInnerResultWindow
        });
      }
    } catch (err) {
      return;
    }
  }
  render() {
    let sizeSlider;
    let sortField;
    let sortOrder;
    if (this.props.topHitsSplitField) {
      sizeSlider = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.maps.source.esSearch.topHitsSizeLabel', {
          defaultMessage: 'Documents per entity'
        }),
        display: this.props.isColumnCompressed ? 'columnCompressed' : 'row'
      }, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
        min: 1,
        max: this.state.maxInnerResultWindow,
        step: 1,
        value: this.props.topHitsSize,
        onChange: this._onTopHitsSizeChange,
        showLabels: true,
        showInput: true,
        showRange: true,
        "data-test-subj": "layerPanelTopHitsSize",
        compressed: true
      }));
      sortField = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.maps.source.esTopHitsSearch.sortFieldLabel', {
          defaultMessage: 'Sort field'
        }),
        display: this.props.isColumnCompressed ? 'columnCompressed' : 'row'
      }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
        placeholder: _i18n.i18n.translate('xpack.maps.source.esSearch.sortFieldSelectPlaceholder', {
          defaultMessage: 'Select sort field'
        }),
        value: this.props.sortField,
        onChange: this._onSortFieldChange,
        fields: this.props.sortFields,
        compressed: true
      }));
      sortOrder = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.maps.source.esTopHitsSearch.sortOrderLabel', {
          defaultMessage: 'Sort order'
        }),
        display: this.props.isColumnCompressed ? 'columnCompressed' : 'row'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        disabled: !this.props.sortField,
        options: [{
          text: _i18n.i18n.translate('xpack.maps.source.esSearch.ascendingLabel', {
            defaultMessage: 'ascending'
          }),
          value: _public.SortDirection.asc
        }, {
          text: _i18n.i18n.translate('xpack.maps.source.esSearch.descendingLabel', {
            defaultMessage: 'descending'
          }),
          value: _public.SortDirection.desc
        }],
        value: this.props.sortOrder,
        onChange: this._onSortOrderChange,
        compressed: true
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.topHitsSplitFieldLabel', {
        defaultMessage: 'Entity'
      }),
      display: this.props.isColumnCompressed ? 'columnCompressed' : 'row'
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.esSearch.topHitsSplitFieldSelectPlaceholder', {
        defaultMessage: 'Select entity field'
      }),
      value: this.props.topHitsSplitField,
      onChange: this._onTopHitsSplitFieldChange,
      fields: this.props.termFields,
      isClearable: false,
      compressed: true
    })), sizeSlider, sortField, sortOrder);
  }
}
exports.TopHitsForm = TopHitsForm;