"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoLineForm = GeoLineForm;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _single_field_select = require("../../../components/single_field_select");
var _index_pattern_util = require("../../../index_pattern_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GeoLineForm(props) {
  function onSortFieldChange(fieldName) {
    if (fieldName !== undefined) {
      props.onSortFieldChange(fieldName);
    }
  }
  function onSplitFieldChange(fieldName) {
    if (fieldName !== undefined) {
      props.onSplitFieldChange(fieldName);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.source.esGeoLine.splitFieldLabel', {
      defaultMessage: 'Entity'
    })
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.maps.source.esGeoLine.splitFieldPlaceholder', {
      defaultMessage: 'Select entity field'
    }),
    value: props.splitField,
    onChange: onSplitFieldChange,
    fields: (0, _index_pattern_util.getTermsFields)(props.indexPattern.fields),
    isClearable: false
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.source.esGeoLine.sortFieldLabel', {
      defaultMessage: 'Sort'
    })
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.maps.source.esGeoLine.sortFieldPlaceholder', {
      defaultMessage: 'Select sort field'
    }),
    value: props.sortField,
    onChange: onSortFieldChange,
    fields: props.indexPattern.fields.filter(field => {
      const isSplitField = props.splitField ? field.name === props.splitField : false;
      return !isSplitField && field.sortable && !_public.indexPatterns.isNestedField(field) && ['number', 'date'].includes(field.type);
    }),
    isClearable: false
  })));
}