"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clustersLayerWizardConfig = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _create_source_editor = require("./create_source_editor");
var _es_geo_grid_source = require("./es_geo_grid_source");
var _vector_layer = require("../../layers/vector_layer");
var _vector_style_defaults = require("../../styles/vector/vector_style_defaults");
var _vector_style = require("../../styles/vector/vector_style");
var _constants = require("../../../../common/constants");
var _color_palettes = require("../../styles/color_palettes");
var _clusters_layer_icon = require("../../layers/wizards/icons/clusters_layer_icon");
var _get_icon_size = require("./get_icon_size");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

const DEFAULT_RESOLUTION = _constants.GRID_RESOLUTION.FINE;
const clustersLayerWizardConfig = {
  id: _constants.WIZARD_ID.CLUSTERS,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.maps.source.esGridClustersDescription', {
    defaultMessage: 'Group Elasticsearch documents into grids and hexagons and display metrics for each group'
  }),
  icon: _clusters_layer_icon.ClustersLayerIcon,
  renderWizard: ({
    previewLayers
  }) => {
    const onSourceConfigChange = sourceConfig => {
      if (!sourceConfig) {
        previewLayers([]);
        return;
      }
      const sourceDescriptor = _es_geo_grid_source.ESGeoGridSource.createDescriptor({
        ...sourceConfig,
        resolution: DEFAULT_RESOLUTION
      });
      const defaultDynamicProperties = (0, _vector_style_defaults.getDefaultDynamicProperties)();
      const style = _vector_style.VectorStyle.createDescriptor({
        // @ts-ignore
        [_constants.VECTOR_STYLES.FILL_COLOR]: {
          type: _constants.STYLE_TYPE.DYNAMIC,
          options: {
            ...defaultDynamicProperties[_constants.VECTOR_STYLES.FILL_COLOR].options,
            field: {
              name: _constants.COUNT_PROP_NAME,
              origin: _constants.FIELD_ORIGIN.SOURCE
            },
            color: _color_palettes.NUMERICAL_COLOR_PALETTES[0].value,
            type: _constants.COLOR_MAP_TYPE.ORDINAL
          }
        },
        [_constants.VECTOR_STYLES.LINE_COLOR]: {
          type: _constants.STYLE_TYPE.STATIC,
          options: {
            color: '#FFF'
          }
        },
        [_constants.VECTOR_STYLES.LINE_WIDTH]: {
          type: _constants.STYLE_TYPE.STATIC,
          options: {
            size: 0
          }
        },
        [_constants.VECTOR_STYLES.ICON_SIZE]: {
          type: _constants.STYLE_TYPE.DYNAMIC,
          options: {
            ...defaultDynamicProperties[_constants.VECTOR_STYLES.ICON_SIZE].options,
            ...(0, _get_icon_size.getIconSize)(DEFAULT_RESOLUTION),
            field: {
              name: _constants.COUNT_PROP_NAME,
              origin: _constants.FIELD_ORIGIN.SOURCE
            }
          }
        },
        [_constants.VECTOR_STYLES.LABEL_TEXT]: {
          type: _constants.STYLE_TYPE.DYNAMIC,
          options: {
            ...defaultDynamicProperties[_constants.VECTOR_STYLES.LABEL_TEXT].options,
            field: {
              name: _constants.COUNT_PROP_NAME,
              origin: _constants.FIELD_ORIGIN.SOURCE
            }
          }
        }
      });
      const layerDescriptor = sourceDescriptor.requestType === _constants.RENDER_AS.HEX ? _vector_layer.MvtVectorLayer.createDescriptor({
        sourceDescriptor,
        style
      }) : _vector_layer.GeoJsonVectorLayer.createDescriptor({
        sourceDescriptor,
        style
      });
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_create_source_editor.CreateSourceEditor, {
      requestType: _constants.RENDER_AS.POINT,
      onSourceConfigChange: onSourceConfigChange
    });
  },
  title: _es_geo_grid_source.clustersTitle
};
exports.clustersLayerWizardConfig = clustersLayerWizardConfig;