"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityLayerWizardConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _security_index_pattern_utils = require("./security_index_pattern_utils");
var _security_layer_template = require("./security_layer_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecurityLayerWizardConfig = {
  id: _constants.WIZARD_ID.SECURITY,
  order: 20,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH, _constants.LAYER_WIZARD_CATEGORY.SOLUTIONS],
  getIsDisabled: async () => {
    const indexPatterns = await (0, _security_index_pattern_utils.getSecurityIndexPatterns)();
    return indexPatterns.length === 0;
  },
  disabledReason: _i18n.i18n.translate('xpack.maps.security.disabledDesc', {
    defaultMessage: 'Cannot find security data view. To get started with Security, go to Security > Overview.'
  }),
  description: _i18n.i18n.translate('xpack.maps.security.desc', {
    defaultMessage: 'Security layers'
  }),
  icon: 'logoSecurity',
  renderWizard: renderWizardArguments => {
    return /*#__PURE__*/_react.default.createElement(_security_layer_template.SecurityLayerTemplate, renderWizardArguments);
  },
  title: _i18n.i18n.translate('xpack.maps.security.title', {
    defaultMessage: 'Security'
  })
};
exports.SecurityLayerWizardConfig = SecurityLayerWizardConfig;