"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerLayerWizards = registerLayerWizards;
var _layer_wizard_registry = require("./layer_wizard_registry");
var _file_upload_wizard = require("./file_upload_wizard");
var _layer_group_wizard = require("./layer_group_wizard");
var _es_search_source = require("../../sources/es_search_source");
var _es_geo_grid_source = require("../../sources/es_geo_grid_source");
var _es_geo_line_source = require("../../sources/es_geo_line_source");
var _point_2_point_layer_wizard = require("../../sources/es_pew_pew_source/point_2_point_layer_wizard");
var _ems_file_source = require("../../sources/ems_file_source");
var _ems_tms_source = require("../../sources/ems_tms_source");
var _kibana_base_map_layer_wizard = require("../../sources/kibana_tilemap_source/kibana_base_map_layer_wizard");
var _xyz_tms_source = require("../../sources/xyz_tms_source");
var _wms_layer_wizard = require("../../sources/wms_source/wms_layer_wizard");
var _mvt_single_layer_vector_source = require("../../sources/mvt_single_layer_vector_source");
var _observability = require("./solution_layers/observability");
var _security = require("./solution_layers/security");
var _choropleth_layer_wizard = require("./choropleth_layer_wizard");
var _new_vector_layer_wizard = require("./new_vector_layer_wizard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let registered = false;
function registerLayerWizards() {
  if (registered) {
    return;
  }
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_file_upload_wizard.uploadLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_layer_group_wizard.layerGroupWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_es_search_source.esDocumentsLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_choropleth_layer_wizard.choroplethLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_es_geo_grid_source.clustersLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_es_geo_grid_source.heatmapLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_es_search_source.esTopHitsLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_es_geo_line_source.geoLineLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_point_2_point_layer_wizard.point2PointLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_ems_file_source.emsBoundariesLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_new_vector_layer_wizard.newVectorLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_ems_tms_source.emsBaseMapLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_kibana_base_map_layer_wizard.kibanaBasemapLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_xyz_tms_source.tmsLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_wms_layer_wizard.wmsLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_mvt_single_layer_vector_source.mvtVectorSourceWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_observability.ObservabilityLayerWizardConfig);
  (0, _layer_wizard_registry.registerLayerWizardInternal)(_security.SecurityLayerWizardConfig);
  registered = true;
}