"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../../common/constants");
var _count_agg_field = require("./count_agg_field");
var _is_metric_countable = require("../../util/is_metric_countable");
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
var _tile_meta_feature_utils = require("../../util/tile_meta_feature_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TERMS_AGG_SHARD_SIZE = 5;
class AggField extends _count_agg_field.CountAggField {
  constructor(params) {
    super(params);
    (0, _defineProperty2.default)(this, "_esDocField", void 0);
    (0, _defineProperty2.default)(this, "_aggType", void 0);
    this._esDocField = params.esDocField;
    this._aggType = params.aggType;
  }
  supportsFieldMetaFromEs() {
    // count and sum aggregations are not within field bounds so they do not support field meta.
    return !(0, _is_metric_countable.isMetricCountable)(this._getAggType());
  }
  supportsFieldMetaFromLocalData() {
    // Elasticsearch vector tile search API returns meta tiles with numeric aggregation metrics.
    return this._getDataTypeSynchronous() === 'number';
  }
  isValid() {
    return !!this._esDocField;
  }
  getMbFieldName() {
    return this._source.isMvt() ? this.getName() + '.value' : this.getName();
  }
  canValueBeFormatted() {
    return this._getAggType() !== _constants.AGG_TYPE.UNIQUE_COUNT;
  }
  isCount() {
    return this._getAggType() === _constants.AGG_TYPE.UNIQUE_COUNT;
  }
  _getAggType() {
    return this._aggType;
  }
  getValueAggDsl(indexPattern) {
    const field = (0, _elasticsearch_util.getField)(indexPattern, this.getRootName());
    const aggType = this._getAggType();
    const aggBody = aggType === _constants.AGG_TYPE.TERMS ? {
      size: 1,
      shard_size: TERMS_AGG_SHARD_SIZE
    } : {};
    return {
      [aggType]: (0, _elasticsearch_util.addFieldToDSL)(aggBody, field)
    };
  }
  getRootName() {
    return this._esDocField ? this._esDocField.getName() : '';
  }
  async getLabel() {
    return this._label ? this._label : await this._source.getAggLabel(this._aggType, this._esDocField ? await this._esDocField.getLabel() : '');
  }
  _getDataTypeSynchronous() {
    return this._getAggType() === _constants.AGG_TYPE.TERMS ? 'string' : 'number';
  }
  async getDataType() {
    return this._getDataTypeSynchronous();
  }
  getBucketCount() {
    // terms aggregation increases the overall number of buckets per split bucket
    return this._getAggType() === _constants.AGG_TYPE.TERMS ? TERMS_AGG_SHARD_SIZE : 0;
  }
  async getExtendedStatsFieldMetaRequest() {
    return this._esDocField ? await this._esDocField.getExtendedStatsFieldMetaRequest() : null;
  }
  async getPercentilesFieldMetaRequest(percentiles) {
    return this._esDocField ? await this._esDocField.getPercentilesFieldMetaRequest(percentiles) : null;
  }
  async getCategoricalFieldMetaRequest(size) {
    return this._esDocField ? await this._esDocField.getCategoricalFieldMetaRequest(size) : null;
  }
  pluckRangeFromTileMetaFeature(metaFeature) {
    return (0, _tile_meta_feature_utils.getAggRange)(metaFeature, this.getName());
  }
}
exports.AggField = AggField;