"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapsEmsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _kibana_services = require("./kibana_services");
var _ems_settings = require("../common/ems_settings");
var _lazy_load_bundle = require("./lazy_load_bundle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class MapsEmsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "_initializerContext", void 0);
    this._initializerContext = initializerContext;
  }
  setup() {
    return {};
  }
  start(code, plugins) {
    const mapConfig = this._initializerContext.config.get();
    const kibanaVersion = this._initializerContext.env.packageInfo.version;
    (0, _kibana_services.setKibanaVersion)(kibanaVersion);
    (0, _kibana_services.setMapConfig)(mapConfig);
    if (plugins.licensing) {
      (0, _kibana_services.setLicensingPluginStart)(plugins.licensing);
    }
    return {
      config: mapConfig,
      createEMSSettings: () => {
        return (0, _ems_settings.createEMSSettings)(mapConfig, _kibana_services.getIsEnterprisePlus);
      },
      createEMSClient: async () => {
        const emsSettings = (0, _ems_settings.createEMSSettings)(mapConfig, _kibana_services.getIsEnterprisePlus);
        return (0, _lazy_load_bundle.createEMSClientLazy)(emsSettings, kibanaVersion);
      }
    };
  }
}
exports.MapsEmsPlugin = MapsEmsPlugin;