"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEMSClient = createEMSClient;
var _i18n = require("@kbn/i18n");
var _emsClient = require("@elastic/ems-client");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createEMSClient(emsSettings, kbnVersion) {
  return new _emsClient.EMSClient({
    language: _i18n.i18n.getLocale(),
    appVersion: kbnVersion,
    appName: _common.EMS_APP_NAME,
    tileApiUrl: emsSettings.getEMSTileApiUrl(),
    fileApiUrl: emsSettings.getEMSFileApiUrl(),
    landingPageUrl: emsSettings.getEMSLandingPageUrl(),
    fetchFunction(url) {
      return fetch(url);
    },
    proxyPath: '',
    emsVersion: kbnVersion
  });
}