"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.managementSidebarNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal **/
const managementSidebarNav = ({
  selectedId,
  sections,
  history
}) => {
  const sectionsToNavItems = managementSections => {
    const sortedManagementSections = (0, _lodash.sortBy)(managementSections, 'order');
    return sortedManagementSections.reduce((acc, section) => {
      const apps = (0, _lodash.sortBy)(section.getAppsEnabled(), 'order');
      if (apps.length) {
        acc.push({
          ...createNavItem(section, {
            items: appsToNavItems(apps)
          })
        });
      }
      return acc;
    }, []);
  };
  const appsToNavItems = managementApps => managementApps.map(app => ({
    ...createNavItem(app, {
      ...(0, _public.reactRouterNavigate)(history, app.basePath)
    })
  }));
  const TooltipWrapper = ({
    text,
    tip
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tip,
    position: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, text), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    size: "s",
    type: "questionInCircle"
  }))));
  const createNavItem = (item, customParams = {}) => {
    const iconType = item.euiIconType || item.icon;
    return {
      id: item.id,
      name: item.tip ? /*#__PURE__*/_react.default.createElement(TooltipWrapper, {
        text: item.title,
        tip: item.tip
      }) : item.title,
      isSelected: item.id === selectedId,
      icon: iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: iconType,
        size: "m"
      }) : undefined,
      'data-test-subj': item.id,
      ...customParams
    };
  };
  return sectionsToNavItems(sections);
};
exports.managementSidebarNav = managementSidebarNav;