"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementAppWrapper = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/core/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ManagementAppWrapper extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "unmount", void 0);
    (0, _defineProperty2.default)(this, "mountElementRef", /*#__PURE__*/(0, _react.createRef)());
  }
  componentDidMount() {
    const {
      setBreadcrumbs,
      app,
      onAppMounted,
      history,
      theme$
    } = this.props;
    const {
      mount,
      basePath
    } = app;
    const appHistory = history.createSubHistory(app.basePath);
    const mountResult = mount({
      basePath,
      setBreadcrumbs: crumbs => setBreadcrumbs(crumbs, appHistory),
      element: this.mountElementRef.current,
      history: appHistory,
      theme$
    });
    onAppMounted(app.id);
    if (mountResult instanceof Promise) {
      mountResult.then(um => {
        this.unmount = um;
      });
    } else {
      this.unmount = mountResult;
    }
  }
  async componentWillUnmount() {
    if (this.unmount) {
      await this.unmount();
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      // The following classes are a stop-gap for this element that wraps children of KibanaPageTemplate
      className: (0, _classnames.default)('euiPageContentBody', _public.APP_WRAPPER_CLASS),
      ref: this.mountElementRef
    });
  }
}
exports.ManagementAppWrapper = ManagementAppWrapper;