"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _management_app_wrapper = require("../management_app_wrapper");
var _landing = require("../landing");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ManagementRouter = /*#__PURE__*/(0, _react.memo)(({
  dependencies,
  history,
  setBreadcrumbs,
  onAppMounted,
  sections,
  theme$
}) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
  history: history
}, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, sections.map(section => section.getAppsEnabled().map(app => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `${app.basePath}`,
  component: () => /*#__PURE__*/_react.default.createElement(_management_app_wrapper.ManagementAppWrapper, {
    app: app,
    setBreadcrumbs: setBreadcrumbs,
    onAppMounted: onAppMounted,
    history: history,
    theme$: theme$
  })
}))), sections.map(section => section.getAppsEnabled().filter(app => app.redirectFrom).map(app => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  path: `/${app.redirectFrom}*`,
  to: `${app.basePath}*`
}))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: '/',
  component: () => /*#__PURE__*/_react.default.createElement(_landing.ManagementLandingPage, {
    version: dependencies.kibanaVersion,
    setBreadcrumbs: setBreadcrumbs,
    onAppMounted: onAppMounted
  })
}))));
exports.ManagementRouter = ManagementRouter;