"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementLandingPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ManagementLandingPage = ({
  version,
  setBreadcrumbs,
  onAppMounted
}) => {
  setBreadcrumbs();
  (0, _react.useEffect)(() => {
    onAppMounted('');
  }, [onAppMounted]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    "data-test-subj": "managementHome",
    iconType: "managementApp",
    title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.header",
      defaultMessage: "Welcome to Stack Management {version}",
      values: {
        version
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.subhead",
      defaultMessage: "Manage your indices, data views, saved objects, Kibana settings, and more."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.text",
      defaultMessage: "A complete list of apps is in the menu on the left."
    })))
  });
};
exports.ManagementLandingPage = ManagementLandingPage;