"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineService = void 0;
var _constants = require("../../../common/constants");
var _pipeline = require("../../models/pipeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PipelineService {
  constructor(http, pipelinesService) {
    this.http = http;
    this.pipelinesService = pipelinesService;
  }
  loadPipeline(id) {
    return this.http.get(`${_constants.ROUTES.API_ROOT}/pipeline/${id}`).then(response => {
      return _pipeline.Pipeline.fromUpstreamJSON(response);
    });
  }
  savePipeline(pipelineModel) {
    return this.http.put(`${_constants.ROUTES.API_ROOT}/pipeline/${pipelineModel.id}`, {
      body: JSON.stringify(pipelineModel.upstreamJSON)
    }).catch(e => {
      throw e.message;
    });
  }
  deletePipeline(id) {
    return this.http.delete(`${_constants.ROUTES.API_ROOT}/pipeline/${id}`).then(() => this.pipelinesService.addToRecentlyDeleted(id)).catch(e => {
      throw e.message;
    });
  }
}
exports.PipelineService = PipelineService;