"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cluster = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Cluster {
  /**
   * Represents the Elasticsearch cluster that Logstash Management is using
   * @param {object} props An object used to instantiate a cluster instance
   * @param {string} props.uuid UUID of the cluster
   */
  constructor(props) {
    this.uuid = (0, _lodash.get)(props, 'uuid');
  }
  static fromUpstreamJSON(cluster) {
    return new Cluster({
      uuid: cluster.uuid
    });
  }
}
exports.Cluster = Cluster;