"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineEditView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _usePromise = _interopRequireDefault(require("react-use/lib/usePromise"));
var _i18n = require("@kbn/i18n");
var _pipeline_editor = require("./components/pipeline_editor");
var _pipeline = require("../models/pipeline");
var Breadcrumbs = _interopRequireWildcard(require("./breadcrumbs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePipeline = (pipelineService, logstashLicenseService, toasts, shouldClone, id) => {
  const mounted = (0, _usePromise.default)();
  const [pipeline, setPipeline] = (0, _react.useState)(null);
  (0, _react.useLayoutEffect)(() => {
    (async () => {
      if (!id) {
        return setPipeline(new _pipeline.Pipeline());
      }
      try {
        const result = await mounted(pipelineService.loadPipeline(id));
        setPipeline(shouldClone ? result.clone : result);
      } catch (e) {
        await logstashLicenseService.checkValidity();
        if (e.status !== 403) {
          toasts.addDanger(_i18n.i18n.translate('xpack.logstash.couldNotLoadPipelineErrorNotification', {
            defaultMessage: `Couldn't load pipeline. Error: '{errStatusText}'.`,
            values: {
              errStatusText: e.statusText
            }
          }));
        }
      }
    })();
  }, [pipelineService, id, mounted, shouldClone, logstashLicenseService, toasts]);
  return pipeline;
};
const PipelineEditView = ({
  pipelineService,
  logstashLicenseService,
  toasts,
  history,
  setBreadcrumbs,
  id
}) => {
  const params = new URLSearchParams(history.location.search);
  const shouldClone = params.get('clone') === '';
  const pipeline = usePipeline(pipelineService, logstashLicenseService, toasts, shouldClone, id);
  const close = (0, _react.useCallback)(() => {
    history.push('/');
  }, [history]);
  const open = (0, _react.useCallback)(newId => {
    history.push(`/pipeline/${newId}/edit`);
  }, [history]);
  if (!pipeline) {
    return null;
  }
  const isNewPipeline = !pipeline.id;
  setBreadcrumbs(isNewPipeline ? Breadcrumbs.getPipelineCreateBreadcrumbs() : Breadcrumbs.getPipelineEditBreadcrumbs(pipeline.id));
  return /*#__PURE__*/_react.default.createElement(_pipeline_editor.PipelineEditor, {
    id: id,
    clone: shouldClone,
    close: close,
    open: open,
    isNewPipeline: isNewPipeline,
    pipeline: pipeline,
    pipelineService: pipelineService,
    toastNotifications: toasts,
    licenseService: logstashLicenseService
  });
};
exports.PipelineEditView = PipelineEditView;