"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlexItemSetting = FlexItemSetting;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _form_label_with_icon_tip = require("./form_label_with_icon_tip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlexItemSetting(props) {
  const {
    formRowLabelText,
    formRowTooltipText
  } = props;
  const label = formRowLabelText && formRowTooltipText ? /*#__PURE__*/_react.default.createElement(_form_label_with_icon_tip.FormLabelWithIconTip, {
    formRowLabelText: formRowLabelText,
    formRowTooltipText: formRowTooltipText
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    hasEmptyLabelSpace: !label
  }, props.children));
}
FlexItemSetting.propTypes = {
  formRowLabelText: _propTypes.default.string,
  formRowTooltipText: _propTypes.default.string
};