"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateOverwriteExceptionListItem = void 0;
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _utils = require("./utils");
var _get_exception_list_item = require("./get_exception_list_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateOverwriteExceptionListItem = async ({
  _version,
  comments,
  entries,
  expireTime,
  id,
  savedObjectsClient,
  namespaceType,
  name,
  osTypes,
  description,
  itemId,
  meta,
  user,
  tags,
  type
}) => {
  const savedObjectType = (0, _securitysolutionListUtils.getSavedObjectType)({
    namespaceType
  });
  const exceptionListItem = await (0, _get_exception_list_item.getExceptionListItem)({
    id,
    itemId,
    namespaceType,
    savedObjectsClient
  });
  if (exceptionListItem == null) {
    return null;
  } else {
    const transformedComments = (0, _utils.transformUpdateCommentsToComments)({
      comments,
      existingComments: exceptionListItem.comments,
      user
    });
    const savedObject = await savedObjectsClient.create(savedObjectType, {
      comments: transformedComments,
      created_at: exceptionListItem.created_at,
      created_by: exceptionListItem.created_by,
      description: description !== null && description !== void 0 ? description : exceptionListItem.description,
      entries,
      expire_time: expireTime,
      immutable: undefined,
      item_id: itemId !== null && itemId !== void 0 ? itemId : exceptionListItem.item_id,
      list_id: exceptionListItem.list_id,
      list_type: 'item',
      meta,
      name: name !== null && name !== void 0 ? name : exceptionListItem.name,
      os_types: osTypes,
      tags: tags !== null && tags !== void 0 ? tags : exceptionListItem.tags,
      tie_breaker_id: exceptionListItem.tie_breaker_id,
      type: type !== null && type !== void 0 ? type : exceptionListItem.type,
      updated_by: user,
      version: exceptionListItem._version ? parseInt(exceptionListItem._version, 10) : undefined
    }, {
      id: id !== null && id !== void 0 ? id : exceptionListItem.id,
      overwrite: true,
      version: _version
    });
    return (0, _utils.transformSavedObjectUpdateToExceptionListItem)({
      exceptionListItem,
      savedObject
    });
  }
};
exports.updateOverwriteExceptionListItem = updateOverwriteExceptionListItem;