"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BuilderAndBadgeComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _and_or_badge = require("../and_or_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyInvisibleAndBadge = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  visibility: hidden;
`;
const MyFirstRowContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-top: 20px;
`;
const BuilderAndBadgeComponent = /*#__PURE__*/_react.default.memo(({
  entriesLength,
  exceptionItemIndex
}) => {
  const badge = /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    includeAntennas: true,
    type: "and"
  });
  if (entriesLength > 1 && exceptionItemIndex === 0) {
    return /*#__PURE__*/_react.default.createElement(MyFirstRowContainer, {
      grow: false,
      "data-test-subj": "exceptionItemEntryFirstRowAndBadge"
    }, badge);
  } else if (entriesLength <= 1) {
    return /*#__PURE__*/_react.default.createElement(MyInvisibleAndBadge, {
      grow: false,
      "data-test-subj": "exceptionItemEntryInvisibleAndBadge"
    }, badge);
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "exceptionItemEntryAndBadge"
    }, badge);
  }
});
exports.BuilderAndBadgeComponent = BuilderAndBadgeComponent;
BuilderAndBadgeComponent.displayName = 'BuilderAndBadge';