"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startBasicLicenseStatus = exports.startBasicLicense = exports.cancelStartBasicLicense = void 0;
var _i18n = require("@kbn/i18n");
var _reduxActions = require("redux-actions");
var _es = require("../../lib/es");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startBasicLicenseStatus = (0, _reduxActions.createAction)('LICENSE_MANAGEMENT_START_BASIC_LICENSE_STATUS');
exports.startBasicLicenseStatus = startBasicLicenseStatus;
const cancelStartBasicLicense = (0, _reduxActions.createAction)('LICENSE_MANAGEMENT_CANCEL_START_BASIC_LICENSE');
exports.cancelStartBasicLicense = cancelStartBasicLicense;
const startBasicLicense = (currentLicenseType, ack) => async (dispatch, getState, {
  licensing,
  toasts,
  http
}) => {
  /*eslint camelcase: 0*/
  const {
    acknowledged,
    basic_was_started,
    error_message,
    acknowledge
  } = await (0, _es.startBasic)(http, ack);
  if (acknowledged) {
    if (basic_was_started) {
      await licensing.refresh();
      // reload necessary to get left nav to refresh with proper links
      window.location.reload();
    } else {
      return toasts.addDanger(error_message);
    }
  } else {
    //messages coming back in arrays
    const messages = Object.values(acknowledge).slice(1).map(item => {
      return item[0];
    });
    const first = _i18n.i18n.translate('xpack.licenseMgmt.replacingCurrentLicenseWithBasicLicenseWarningMessage', {
      defaultMessage: 'Some functionality will be lost if you replace your {currentLicenseType} license with a BASIC license. Review the list of features below.',
      values: {
        currentLicenseType: currentLicenseType.toUpperCase()
      }
    });
    dispatch(startBasicLicenseStatus({
      acknowledge: true,
      messages: [first, ...messages]
    }));
  }
};
exports.startBasicLicense = startBasicLicense;