"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sections = require("./sections");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _shared_imports = require("../shared_imports");
var _eui = require("@elastic/eui");
var _locator = require("../locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = ({
  hasPermission,
  permissionsLoading,
  permissionsError,
  telemetry,
  loadPermissions,
  executionContext
}) => {
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'licenseManagement'
  });
  (0, _react.useEffect)(() => {
    loadPermissions();
  }, [loadPermissions]);
  if (permissionsLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.app.loadingPermissionsDescription",
      defaultMessage: "Checking permissions\u2026"
    })));
  }
  if (permissionsError) {
    var _permissionsError$dat;
    const error = permissionsError === null || permissionsError === void 0 ? void 0 : (_permissionsError$dat = permissionsError.data) === null || _permissionsError$dat === void 0 ? void 0 : _permissionsError$dat.message;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.checkingPermissionsErrorMessage",
        defaultMessage: "Error checking permissions"
      })),
      body: error ? /*#__PURE__*/_react.default.createElement("p", null, error) : null
    }));
  }
  if (!hasPermission) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "securityApp",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.deniedPermissionTitle",
        defaultMessage: "Cluster privileges required"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.app.deniedPermissionDescription",
        defaultMessage: "To use License Management, you must have {permissionType} privileges.",
        values: {
          permissionType: /*#__PURE__*/_react.default.createElement("strong", null, _constants.APP_PERMISSION)
        }
      }))
    }));
  }
  const withTelemetry = Component => props => /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
    telemetry: telemetry
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/${_locator.UPLOAD_LICENSE_ROUTE}`,
    component: withTelemetry(_sections.UploadLicense)
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/'],
    component: withTelemetry(_sections.LicenseDashboard)
  })));
};
exports.App = App;