"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineCurveOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LineCurveOption = ({
  onChange,
  value,
  isCurveTypeEnabled = true
}) => {
  return isCurveTypeEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressedSwitch",
    label: _i18n.i18n.translate('xpack.lens.xyChart.curveStyleLabel', {
      defaultMessage: 'Curve lines'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    showLabel: false,
    label: "Curved",
    checked: value === 'CURVE_MONOTONE_X',
    compressed: true,
    onChange: e => {
      if (e.target.checked) {
        onChange('CURVE_MONOTONE_X');
      } else {
        onChange('LINEAR');
      }
    },
    "data-test-subj": "lnsCurveStyleToggle"
  })) : null;
};
exports.LineCurveOption = LineCurveOption;