"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualOptionsPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_components = require("../../../../shared_components");
var _missing_values_option = require("./missing_values_option");
var _line_curve_option = require("./line_curve_option");
var _fill_opacity_option = require("./fill_opacity_option");
var _state_helpers = require("../../state_helpers");
var _visualization_helpers = require("../../visualization_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getValueLabelDisableReason({
  isAreaPercentage,
  isHistogramSeries
}) {
  if (isHistogramSeries) {
    return _i18n.i18n.translate('xpack.lens.xyChart.valuesHistogramDisabledHelpText', {
      defaultMessage: 'This setting cannot be changed on histograms.'
    });
  }
  if (isAreaPercentage) {
    return _i18n.i18n.translate('xpack.lens.xyChart.valuesPercentageDisabledHelpText', {
      defaultMessage: 'This setting cannot be changed on percentage area charts.'
    });
  }
  return _i18n.i18n.translate('xpack.lens.xyChart.valuesStackedDisabledHelpText', {
    defaultMessage: 'This setting cannot be changed on stacked or percentage bar charts'
  });
}
const VisualOptionsPopover = ({
  state,
  setState,
  datasourceLayers
}) => {
  var _state$valueLabels, _state$fillOpacity;
  const dataLayers = (0, _visualization_helpers.getDataLayers)(state.layers);
  const isAreaPercentage = dataLayers.some(({
    seriesType
  }) => seriesType === 'area_percentage_stacked');
  const hasNonBarSeries = dataLayers.some(({
    seriesType
  }) => ['area_stacked', 'area', 'line', 'area_percentage_stacked'].includes(seriesType));
  const hasAreaSeries = dataLayers.some(({
    seriesType
  }) => ['area_stacked', 'area', 'area_percentage_stacked'].includes(seriesType));
  const isHistogramSeries = Boolean((0, _state_helpers.hasHistogramSeries)(dataLayers, datasourceLayers));
  const isValueLabelsEnabled = !hasNonBarSeries;
  const isFittingEnabled = hasNonBarSeries && !isAreaPercentage;
  const isCurveTypeEnabled = hasNonBarSeries || isAreaPercentage;
  const valueLabelsDisabledReason = getValueLabelDisableReason({
    isAreaPercentage,
    isHistogramSeries
  });
  const isDisabled = !isValueLabelsEnabled && !isFittingEnabled && !isCurveTypeEnabled;
  return /*#__PURE__*/_react.default.createElement(_shared_components.TooltipWrapper, {
    tooltipContent: valueLabelsDisabledReason,
    condition: isDisabled
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.shared.curveLabel', {
      defaultMessage: 'Visual options'
    }),
    type: "visualOptions",
    groupPosition: "left",
    buttonDataTestSubj: "lnsVisualOptionsButton",
    isDisabled: isDisabled
  }, /*#__PURE__*/_react.default.createElement(_line_curve_option.LineCurveOption, {
    isCurveTypeEnabled: isCurveTypeEnabled,
    value: state === null || state === void 0 ? void 0 : state.curveType,
    onChange: id => {
      setState({
        ...state,
        curveType: id
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_components.ValueLabelsSettings, {
    isVisible: isValueLabelsEnabled,
    valueLabels: (_state$valueLabels = state === null || state === void 0 ? void 0 : state.valueLabels) !== null && _state$valueLabels !== void 0 ? _state$valueLabels : 'hide',
    onValueLabelChange: newMode => {
      setState({
        ...state,
        valueLabels: newMode
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_values_option.MissingValuesOptions, {
    isFittingEnabled: isFittingEnabled,
    fittingFunction: state === null || state === void 0 ? void 0 : state.fittingFunction,
    emphasizeFitting: state === null || state === void 0 ? void 0 : state.emphasizeFitting,
    endValue: state === null || state === void 0 ? void 0 : state.endValue,
    onFittingFnChange: newVal => {
      setState({
        ...state,
        fittingFunction: newVal
      });
    },
    onEmphasizeFittingChange: newVal => {
      setState({
        ...state,
        emphasizeFitting: newVal
      });
    },
    onEndValueChange: newVal => {
      setState({
        ...state,
        endValue: newVal
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_fill_opacity_option.FillOpacityOption, {
    isFillOpacityEnabled: hasAreaSeries,
    value: (_state$fillOpacity = state === null || state === void 0 ? void 0 : state.fillOpacity) !== null && _state$fillOpacity !== void 0 ? _state$fillOpacity : 0.3,
    onChange: newValue => {
      setState({
        ...state,
        fillOpacity: newValue
      });
    }
  })));
};
exports.VisualOptionsPopover = VisualOptionsPopover;