"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconSelectSetting = IconSelectSetting;
exports.MarkerDecorationPosition = MarkerDecorationPosition;
exports.TextDecorationSetting = TextDecorationSetting;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_components = require("../../../../shared_components");
var _icon_select = require("../../../../shared_components/icon_select/icon_select");
var _dimension_editor = require("../dimension_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const topLabel = _i18n.i18n.translate('xpack.lens.xyChart.markerPosition.above', {
  defaultMessage: 'Top'
});
const bottomLabel = _i18n.i18n.translate('xpack.lens.xyChart.markerPosition.below', {
  defaultMessage: 'Bottom'
});
const leftLabel = _i18n.i18n.translate('xpack.lens.xyChart.markerPosition.left', {
  defaultMessage: 'Left'
});
const rightLabel = _i18n.i18n.translate('xpack.lens.xyChart.markerPosition.right', {
  defaultMessage: 'Right'
});
function getIconPositionOptions({
  isHorizontal,
  axisMode
}) {
  const autoOption = {
    id: `${_dimension_editor.idPrefix}auto`,
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.auto', {
      defaultMessage: 'Auto'
    }),
    'data-test-subj': 'lnsXY_markerPosition_auto'
  };
  if (axisMode === 'bottom') {
    return [{
      id: `${_dimension_editor.idPrefix}below`,
      label: isHorizontal ? leftLabel : bottomLabel,
      'data-test-subj': 'lnsXY_markerPosition_below'
    }, autoOption, {
      id: `${_dimension_editor.idPrefix}above`,
      label: isHorizontal ? rightLabel : topLabel,
      'data-test-subj': 'lnsXY_markerPosition_above'
    }];
  }
  return [{
    id: `${_dimension_editor.idPrefix}left`,
    label: isHorizontal ? bottomLabel : leftLabel,
    'data-test-subj': 'lnsXY_markerPosition_left'
  }, autoOption, {
    id: `${_dimension_editor.idPrefix}right`,
    label: isHorizontal ? topLabel : rightLabel,
    'data-test-subj': 'lnsXY_markerPosition_right'
  }];
}
function getSelectedOption({
  textField,
  textVisibility
} = {}, isQueryBased) {
  if (!textVisibility) {
    return 'none';
  }
  if (isQueryBased && textField) {
    return 'field';
  }
  return 'name';
}
function TextDecorationSetting({
  currentConfig,
  setConfig,
  isQueryBased,
  children
}) {
  // To model the temporary state for label based on field when user didn't pick up the field yet,
  // use a local state
  const [selectedVisibleOption, setVisibleOption] = (0, _react.useState)(getSelectedOption(currentConfig, isQueryBased));
  const options = [{
    id: `${_dimension_editor.idPrefix}none`,
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.textVisibility.none', {
      defaultMessage: 'None'
    }),
    'data-test-subj': 'lnsXY_textVisibility_none'
  }, {
    id: `${_dimension_editor.idPrefix}name`,
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.textVisibility.name', {
      defaultMessage: 'Name'
    }),
    'data-test-subj': 'lnsXY_textVisibility_name'
  }];
  if (isQueryBased) {
    options.push({
      id: `${_dimension_editor.idPrefix}field`,
      label: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.textVisibility.field', {
        defaultMessage: 'Field'
      }),
      'data-test-subj': 'lnsXY_textVisibility_field'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.lineMarker.textVisibility', {
      defaultMessage: 'Text decoration'
    }),
    display: "columnCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.lineMarker.textVisibility', {
      defaultMessage: 'Text decoration'
    }),
    "data-test-subj": "lns-lineMarker-text-visibility",
    name: "textVisibilityStyle",
    buttonSize: "compressed",
    options: options,
    idSelected: selectedVisibleOption ? `${_dimension_editor.idPrefix}${selectedVisibleOption}` : `${_dimension_editor.idPrefix}none`,
    onChange: id => {
      const chosenOption = id.replace(_dimension_editor.idPrefix, '');
      if (chosenOption === 'none') {
        setConfig({
          textVisibility: false,
          textField: undefined
        });
      } else if (chosenOption === 'name') {
        setConfig({
          textVisibility: true,
          textField: undefined
        });
      } else if (chosenOption === 'field') {
        setConfig({
          textVisibility: Boolean(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.textField)
        });
      }
      setVisibleOption(chosenOption);
    },
    isFullWidth: true
  }), children === null || children === void 0 ? void 0 : children(selectedVisibleOption)));
}
function IconSelectSetting({
  currentConfig,
  setConfig,
  customIconSet,
  defaultIcon = 'empty'
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.icon', {
      defaultMessage: 'Icon decoration'
    })
  }, /*#__PURE__*/_react.default.createElement(_icon_select.IconSelect, {
    defaultIcon: defaultIcon,
    customIconSet: customIconSet,
    value: currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon,
    onChange: newIcon => {
      setConfig({
        icon: newIcon
      });
    }
  }));
}
function MarkerDecorationPosition({
  currentConfig,
  setConfig,
  isHorizontal
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _icon_select.hasIcon)(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon) || currentConfig !== null && currentConfig !== void 0 && currentConfig.textVisibility ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    isDisabled: !(0, _icon_select.hasIcon)(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon) && !(currentConfig !== null && currentConfig !== void 0 && currentConfig.textVisibility),
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.position', {
      defaultMessage: 'Decoration position'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_components.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('xpack.lens.lineMarker.positionRequirementTooltip', {
      defaultMessage: 'You must select an icon or show the name in order to alter its position'
    }),
    condition: !(0, _icon_select.hasIcon)(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon) && !(currentConfig !== null && currentConfig !== void 0 && currentConfig.textVisibility),
    position: "top",
    delay: "regular",
    display: "block"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.position', {
      defaultMessage: 'Decoration position'
    }),
    "data-test-subj": "lnsXY_markerPosition",
    name: "markerPosition",
    isDisabled: !(0, _icon_select.hasIcon)(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon) && !(currentConfig !== null && currentConfig !== void 0 && currentConfig.textVisibility),
    buttonSize: "compressed",
    options: getIconPositionOptions({
      isHorizontal,
      axisMode: currentConfig.axisMode
    }),
    idSelected: `${_dimension_editor.idPrefix}${(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.iconPosition) || 'auto'}`,
    onChange: id => {
      const newMode = id.replace(_dimension_editor.idPrefix, '');
      setConfig({
        iconPosition: newMode
      });
    }
  }))) : null);
}