"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceLinePanel = exports.FillSetting = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _color_picker = require("../color_picker");
var _ = require("..");
var _shared_components = require("../../../../shared_components");
var _dimension_editor = require("../dimension_editor");
var _state_helpers = require("../../state_helpers");
var _marker_decoration_settings = require("../shared/marker_decoration_settings");
var _line_style_settings = require("../shared/line_style_settings");
var _icon_set = require("./icon_set");
var _color_assignment = require("../../color_assignment");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReferenceLinePanel = props => {
  var _localLayer$yConfig;
  const {
    state,
    setState,
    layerId,
    accessor
  } = props;
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _shared_components.useDebouncedValue)({
    value: state,
    onChange: setState
  });
  const localLayer = localState.layers.find(l => l.layerId === layerId);
  const localConfig = localLayer === null || localLayer === void 0 ? void 0 : (_localLayer$yConfig = localLayer.yConfig) === null || _localLayer$yConfig === void 0 ? void 0 : _localLayer$yConfig.find(yAxisConfig => yAxisConfig.forAccessor === accessor);
  const setConfig = (0, _react.useCallback)(yConfig => {
    if (yConfig == null) {
      return;
    }
    const newYConfigs = [...(localLayer.yConfig || [])];
    const existingIndex = newYConfigs.findIndex(yAxisConfig => yAxisConfig.forAccessor === accessor);
    if (existingIndex !== -1) {
      newYConfigs[existingIndex] = {
        ...newYConfigs[existingIndex],
        ...yConfig
      };
    } else {
      newYConfigs.push({
        forAccessor: accessor,
        ...yConfig
      });
    }
    setLocalState((0, _.updateLayer)(localState, {
      ...localLayer,
      yConfig: newYConfigs
    }, index));
  }, [accessor, index, localState, localLayer, setLocalState]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_marker_decoration_settings.TextDecorationSetting, {
    setConfig: setConfig,
    currentConfig: localConfig
  }), /*#__PURE__*/_react.default.createElement(_marker_decoration_settings.IconSelectSetting, {
    setConfig: setConfig,
    currentConfig: localConfig,
    customIconSet: _icon_set.referenceLineIconsSet
  }), /*#__PURE__*/_react.default.createElement(_marker_decoration_settings.MarkerDecorationPosition, {
    isHorizontal: isHorizontal,
    setConfig: setConfig,
    currentConfig: localConfig
  }), /*#__PURE__*/_react.default.createElement(_line_style_settings.LineStyleSettings, {
    isHorizontal: isHorizontal,
    setConfig: setConfig,
    currentConfig: localConfig
  }), /*#__PURE__*/_react.default.createElement(FillSetting, {
    isHorizontal: isHorizontal,
    setConfig: setConfig,
    currentConfig: localConfig
  }), /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, (0, _extends2.default)({}, props, {
    overwriteColor: localConfig === null || localConfig === void 0 ? void 0 : localConfig.color,
    defaultColor: _color_assignment.defaultReferenceLineColor,
    setConfig: setConfig,
    disableHelpTooltip: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineColor.label', {
      defaultMessage: 'Color'
    })
  })));
};
exports.ReferenceLinePanel = ReferenceLinePanel;
function getFillPositionOptions({
  isHorizontal,
  axisMode
}) {
  const aboveLabel = _i18n.i18n.translate('xpack.lens.xyChart.fill.above', {
    defaultMessage: 'Above'
  });
  const belowLabel = _i18n.i18n.translate('xpack.lens.xyChart.fill.below', {
    defaultMessage: 'Below'
  });
  const beforeLabel = _i18n.i18n.translate('xpack.lens.xyChart.fill.before', {
    defaultMessage: 'Before'
  });
  const afterLabel = _i18n.i18n.translate('xpack.lens.xyChart.fill.after', {
    defaultMessage: 'After'
  });
  const aboveOptionLabel = axisMode !== 'bottom' && !isHorizontal ? aboveLabel : afterLabel;
  const belowOptionLabel = axisMode !== 'bottom' && !isHorizontal ? belowLabel : beforeLabel;
  return [{
    id: `${_dimension_editor.idPrefix}none`,
    label: _i18n.i18n.translate('xpack.lens.xyChart.fill.none', {
      defaultMessage: 'None'
    }),
    'data-test-subj': 'lnsXY_fill_none'
  }, {
    id: `${_dimension_editor.idPrefix}above`,
    label: aboveOptionLabel,
    'data-test-subj': 'lnsXY_fill_above'
  }, {
    id: `${_dimension_editor.idPrefix}below`,
    label: belowOptionLabel,
    'data-test-subj': 'lnsXY_fill_below'
  }];
}
const FillSetting = ({
  currentConfig,
  setConfig,
  isHorizontal
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.fill.label', {
      defaultMessage: 'Fill'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.fill.label', {
      defaultMessage: 'Fill'
    }),
    "data-test-subj": "lnsXY_fill",
    name: "fill",
    buttonSize: "compressed",
    options: getFillPositionOptions({
      isHorizontal,
      axisMode: currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.axisMode
    }),
    idSelected: `${_dimension_editor.idPrefix}${(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.fill) || 'none'}`,
    onChange: id => {
      const newMode = id.replace(_dimension_editor.idPrefix, '');
      setConfig({
        fill: newMode
      });
    }
  }));
};
exports.FillSetting = FillSetting;