"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDimensionEditor = DataDimensionEditor;
exports.DataDimensionEditorDataSectionExtra = DataDimensionEditorDataSectionExtra;
exports.DimensionEditor = DimensionEditor;
exports.idPrefix = void 0;
exports.updateLayer = updateLayer;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _state_helpers = require("../state_helpers");
var _color_picker = require("./color_picker");
var _shared_components = require("../../../shared_components");
var _visualization_helpers = require("../visualization_helpers");
var _reference_line_config_panel = require("./reference_line_config_panel");
var _annotations_config_panel = require("./annotations_config_panel");
var _collapse_setting = require("../../../shared_components/collapse_setting");
var _to_expression = require("../to_expression");
var _color_assignment = require("../color_assignment");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function updateLayer(state, layer, index) {
  const newLayers = [...state.layers];
  newLayers[index] = layer;
  return {
    ...state,
    layers: newLayers
  };
}
const idPrefix = (0, _eui.htmlIdGenerator)()();
exports.idPrefix = idPrefix;
function DimensionEditor(props) {
  const {
    state,
    layerId
  } = props;
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[index];
  if ((0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    return /*#__PURE__*/_react.default.createElement(_annotations_config_panel.AnnotationsPanel, props);
  }
  if ((0, _visualization_helpers.isReferenceLayer)(layer)) {
    return /*#__PURE__*/_react.default.createElement(_reference_line_config_panel.ReferenceLinePanel, props);
  }
  return /*#__PURE__*/_react.default.createElement(DataDimensionEditor, props);
}
function DataDimensionEditor(props) {
  var _layer$yConfig;
  const {
    state,
    setState,
    layerId,
    accessor
  } = props;
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[index];
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _shared_components.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  const localYConfig = layer === null || layer === void 0 ? void 0 : (_layer$yConfig = layer.yConfig) === null || _layer$yConfig === void 0 ? void 0 : _layer$yConfig.find(yAxisConfig => yAxisConfig.forAccessor === accessor);
  const axisMode = (localYConfig === null || localYConfig === void 0 ? void 0 : localYConfig.axisMode) || 'auto';
  const setConfig = (0, _react.useCallback)(yConfig => {
    if (yConfig == null) {
      return;
    }
    const newYConfigs = [...(layer.yConfig || [])];
    const existingIndex = newYConfigs.findIndex(yAxisConfig => yAxisConfig.forAccessor === accessor);
    if (existingIndex !== -1) {
      newYConfigs[existingIndex] = {
        ...newYConfigs[existingIndex],
        ...yConfig
      };
    } else {
      newYConfigs.push({
        forAccessor: accessor,
        ...yConfig
      });
    }
    setLocalState(updateLayer(localState, {
      ...layer,
      yConfig: newYConfigs
    }, index));
  }, [accessor, index, localState, layer, setLocalState]);
  const overwriteColor = (0, _state_helpers.getSeriesColor)(layer, accessor);
  const assignedColor = (0, _react.useMemo)(() => {
    var _props$frame$activeDa;
    const sortedAccessors = (0, _to_expression.getSortedAccessors)(props.frame.datasourceLayers[layer.layerId], layer);
    const colorAssignments = (0, _color_assignment.getColorAssignments)((0, _visualization_helpers.getDataLayers)(state.layers), {
      tables: (_props$frame$activeDa = props.frame.activeData) !== null && _props$frame$activeDa !== void 0 ? _props$frame$activeDa : {}
    }, props.formatFactory);
    return (0, _color_assignment.getAssignedColorConfig)({
      ...layer,
      accessors: sortedAccessors.filter(sorted => layer.accessors.includes(sorted))
    }, accessor, colorAssignments, props.frame, props.paletteService).color;
  }, [props.frame, props.paletteService, state.layers, accessor, props.formatFactory, layer]);
  const localLayer = layer;
  if (props.groupId === 'breakdown') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !layer.collapseFn && /*#__PURE__*/_react.default.createElement(_shared_components.PalettePicker, {
      palettes: props.paletteService,
      activePalette: localLayer === null || localLayer === void 0 ? void 0 : localLayer.palette,
      setPalette: newPalette => {
        setState(updateLayer(localState, {
          ...localLayer,
          palette: newPalette
        }, index));
      }
    }));
  }
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, (0, _extends2.default)({}, props, {
    overwriteColor: overwriteColor,
    defaultColor: assignedColor,
    disabled: Boolean(!localLayer.collapseFn && localLayer.splitAccessor),
    setConfig: setConfig
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.label', {
      defaultMessage: 'Axis side'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.label', {
      defaultMessage: 'Axis side'
    }),
    "data-test-subj": "lnsXY_axisSide_groups",
    name: "axisSide",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}left`,
      label: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.axisSide.bottom', {
        defaultMessage: 'Bottom'
      }) : _i18n.i18n.translate('xpack.lens.xyChart.axisSide.left', {
        defaultMessage: 'Left'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_left'
    }, {
      id: `${idPrefix}auto`,
      label: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.auto', {
        defaultMessage: 'Auto'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_auto'
    }, {
      id: `${idPrefix}right`,
      label: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.axisSide.top', {
        defaultMessage: 'Top'
      }) : _i18n.i18n.translate('xpack.lens.xyChart.axisSide.right', {
        defaultMessage: 'Right'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_right'
    }],
    idSelected: `${idPrefix}${axisMode}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setConfig({
        axisMode: newMode
      });
    }
  })));
}
function DataDimensionEditorDataSectionExtra(props) {
  const {
    state,
    layerId
  } = props;
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[index];
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _shared_components.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  if (props.groupId === 'breakdown') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapse_setting.CollapseSetting, {
      value: layer.collapseFn || '',
      onChange: collapseFn => {
        setLocalState(updateLayer(localState, {
          ...layer,
          collapseFn
        }, index));
      }
    }));
  }
  return null;
}