"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPicker = void 0;
exports.isValidColor = isValidColor;
var _react = _interopRequireWildcard(require("react"));
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_components = require("../../../shared_components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tooltipContent = {
  auto: _i18n.i18n.translate('xpack.lens.configPanel.color.tooltip.auto', {
    defaultMessage: 'Lens automatically picks colors for you unless you specify a custom color.'
  }),
  custom: _i18n.i18n.translate('xpack.lens.configPanel.color.tooltip.custom', {
    defaultMessage: 'Clear the custom color to return to “Auto” mode.'
  }),
  disabled: _i18n.i18n.translate('xpack.lens.configPanel.color.tooltip.disabled', {
    defaultMessage: 'You are unable to apply custom colors to individual series when the layer includes a "Break down by" field.'
  })
};

// copied from coloring package
function isValidPonyfill(colorString) {
  // we're using an old version of chroma without the valid function
  try {
    (0, _chromaJs.default)(colorString);
    return true;
  } catch (e) {
    return false;
  }
}
function isValidColor(colorString) {
  // chroma can handle also hex values with alpha channel/transparency
  // chroma accepts also hex without #, so test for it
  return colorString && colorString !== '' && /^#/.test(colorString) && isValidPonyfill(colorString);
}
const getColorAlpha = color => {
  var _chroma;
  return color && isValidColor(color) && ((_chroma = (0, _chromaJs.default)(color)) === null || _chroma === void 0 ? void 0 : _chroma.alpha()) || 1;
};
const ColorPicker = ({
  label,
  disableHelpTooltip,
  disabled,
  setConfig,
  defaultColor,
  overwriteColor,
  showAlpha
}) => {
  const [colorText, setColorText] = (0, _react.useState)(overwriteColor || defaultColor);
  const [validatedColor, setValidatedColor] = (0, _react.useState)(overwriteColor || defaultColor);
  const [currentColorAlpha, setCurrentColorAlpha] = (0, _react.useState)(getColorAlpha(colorText));
  const unflushedChanges = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    //  only the changes from outside the color picker should be applied
    if (!unflushedChanges.current) {
      // something external changed the color that is currently selected (switching from annotation line to annotation range)
      if (overwriteColor && validatedColor && overwriteColor.toUpperCase() !== validatedColor.toUpperCase()) {
        setColorText(overwriteColor);
        setValidatedColor(overwriteColor.toUpperCase());
        setCurrentColorAlpha(getColorAlpha(overwriteColor));
      }
    }
    unflushedChanges.current = false;
  }, [validatedColor, overwriteColor, defaultColor]);
  const handleColor = (text, output) => {
    setColorText(text);
    unflushedChanges.current = true;
    if (output.isValid) {
      setValidatedColor(output.hex.toUpperCase());
      setCurrentColorAlpha(getColorAlpha(output.hex));
      setConfig({
        color: output.hex
      });
    }
    if (text === '') {
      setConfig({
        color: undefined
      });
    }
  };
  const inputLabel = label !== null && label !== void 0 ? label : _i18n.i18n.translate('xpack.lens.xyChart.seriesColor.label', {
    defaultMessage: 'Series color'
  });
  const colorPicker = /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    fullWidth: true,
    "data-test-subj": "indexPattern-dimension-colorPicker",
    compressed: true,
    isClearable: Boolean(overwriteColor),
    onChange: handleColor,
    color: disabled ? '' : colorText,
    disabled: disabled,
    placeholder: (defaultColor === null || defaultColor === void 0 ? void 0 : defaultColor.toUpperCase()) || _i18n.i18n.translate('xpack.lens.xyChart.seriesColor.auto', {
      defaultMessage: 'Auto'
    }),
    "aria-label": inputLabel,
    showAlpha: showAlpha,
    swatches: currentColorAlpha === 1 ? (0, _eui.euiPaletteColorBlind)() : (0, _eui.euiPaletteColorBlind)().map(c => (0, _chromaJs.default)(c).alpha(currentColorAlpha).hex())
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_shared_components.TooltipWrapper, {
      delay: "long",
      position: "top",
      tooltipContent: colorText && !disabled ? tooltipContent.custom : tooltipContent.auto,
      condition: !disableHelpTooltip
    }, /*#__PURE__*/_react.default.createElement("span", null, inputLabel, !disableHelpTooltip && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: "subdued",
      size: "s",
      className: "eui-alignTop"
    }))))
  }, disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipContent.disabled,
    delay: "long",
    anchorClassName: "eui-displayBlock"
  }, colorPicker) : colorPicker);
};
exports.ColorPicker = ColorPicker;