"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_TOOLTIP_FIELDS_SIZE = void 0;
exports.TooltipSection = TooltipSection;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-field-list-plugin/public");
var _shared_components = require("../../../../shared_components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_TOOLTIP_FIELDS_SIZE = 2;
exports.MAX_TOOLTIP_FIELDS_SIZE = MAX_TOOLTIP_FIELDS_SIZE;
const generateId = (0, _eui.htmlIdGenerator)();
const supportedTypes = new Set(['string', 'boolean', 'number', 'ip', 'date']);
function removeNewEmptyField(v) {
  return v.value != null;
}
function TooltipSection({
  currentConfig,
  setConfig,
  indexPattern,
  invalidFields
}) {
  const {
    hasFieldData
  } = (0, _public.useExistingFieldsReader)();
  const onChangeWrapped = (0, _react.useCallback)(values => {
    setConfig({
      ...currentConfig,
      extraFields: values.filter(removeNewEmptyField).map(({
        value
      }) => value)
    });
  }, [setConfig, currentConfig]);
  const {
    wrappedValues,
    rawValuesLookup
  } = (0, _react.useMemo)(() => {
    var _currentConfig$extraF;
    const rawValues = (_currentConfig$extraF = currentConfig.extraFields) !== null && _currentConfig$extraF !== void 0 ? _currentConfig$extraF : [];
    return {
      wrappedValues: rawValues.map(value => ({
        id: generateId(),
        value
      })),
      rawValuesLookup: new Set(rawValues)
    };
  }, [currentConfig]);
  const {
    inputValue: localValues,
    handleInputChange
  } = (0, _shared_components.useDebouncedValue)({
    onChange: onChangeWrapped,
    value: wrappedValues
  });
  const onFieldSelectChange = (0, _react.useCallback)((choice, index = 0) => {
    const fields = [...localValues];
    if (indexPattern.getFieldByName(choice.field)) {
      fields[index] = {
        id: generateId(),
        value: choice.field
      };

      // update the layer state
      handleInputChange(fields);
    }
  }, [localValues, indexPattern, handleInputChange]);
  const newBucketButton = /*#__PURE__*/_react.default.createElement(_shared_components.NewBucketButton, {
    className: "lnsConfigPanelAnnotations__addButton",
    "data-test-subj": `lnsXY-annotation-tooltip-add_field`,
    onClick: () => {
      handleInputChange([...localValues, {
        id: generateId(),
        value: undefined,
        isNew: true
      }]);
    },
    label: _i18n.i18n.translate('xpack.lens.xyChart.annotation.tooltip.addField', {
      defaultMessage: 'Add field'
    }),
    isDisabled: localValues.length > MAX_TOOLTIP_FIELDS_SIZE
  });
  if (localValues.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "s",
      className: "lnsConfigPanelAnnotations__noFieldsPrompt"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      textAlign: "center"
    }, _i18n.i18n.translate('xpack.lens.xyChart.annotation.tooltip.noFields', {
      defaultMessage: 'None selected'
    })))), newBucketButton);
  }
  const options = indexPattern.fields.filter(({
    displayName,
    type
  }) => displayName && !rawValuesLookup.has(displayName) && supportedTypes.has(type)).map(field => ({
    label: field.displayName,
    value: {
      type: 'field',
      field: field.name,
      dataType: field.type
    },
    exists: hasFieldData(indexPattern.id, field.name),
    compatible: true,
    'data-test-subj': `lnsXY-annotation-tooltip-fieldOption-${field.name}`
  })).sort((a, b) => a.label.localeCompare(b.label));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_components.DragDropBuckets, {
    onDragEnd: updatedValues => {
      handleInputChange(updatedValues);
    },
    droppableId: "ANNOTATION_TOOLTIP_DROPPABLE_AREA",
    items: localValues,
    bgColor: "subdued"
  }, localValues.map(({
    id,
    value,
    isNew
  }, index, arrayRef) => {
    const fieldIsValid = value ? Boolean(indexPattern.getFieldByName(value)) : true;
    return /*#__PURE__*/_react.default.createElement(_shared_components.DraggableBucketContainer, {
      id: (value !== null && value !== void 0 ? value : 'newField') + id,
      key: (value !== null && value !== void 0 ? value : 'newField') + id,
      idx: index,
      onRemoveClick: () => {
        handleInputChange(arrayRef.filter((_, i) => i !== index));
      },
      removeTitle: _i18n.i18n.translate('xpack.lens.xyChart.annotation.tooltip.deleteButtonLabel', {
        defaultMessage: 'Delete'
      }),
      isNotDraggable: arrayRef.length < 2,
      Container: _shared_components.FieldsBucketContainer,
      isInsidePanel: true,
      "data-test-subj": `lnsXY-annotation-tooltip-${index}`
    }, /*#__PURE__*/_react.default.createElement(_shared_components.FieldPicker, {
      selectedOptions: value ? [{
        label: value,
        value: {
          type: 'field',
          field: value
        }
      }] : [],
      options: options,
      onChoose: choice => {
        onFieldSelectChange(choice, index);
      },
      fieldIsInvalid: !fieldIsValid,
      className: "lnsConfigPanelAnnotations__fieldPicker",
      "data-test-subj": `lnsXY-annotation-tooltip-field-picker--${index}`,
      autoFocus: isNew && value == null
    }));
  })), newBucketButton);
}