"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigPanelRangeDatePicker = exports.ConfigPanelApplyAsRangeSwitch = void 0;
var _public = require("@kbn/event-annotation-plugin/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _utils = require("../../../../utils");
var _helpers = require("../../annotations/helpers");
var _visualization_helpers = require("../../visualization_helpers");
var _helpers2 = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigPanelApplyAsRangeSwitch = ({
  annotation,
  datatableUtilities,
  onChange,
  frame,
  state
}) => {
  const isRange = (0, _public.isRangeAnnotationConfig)(annotation);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    className: "lnsRowCompressedMargin"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "lns-xyAnnotation-rangeSwitch",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('xpack.lens.xyChart.applyAsRange', {
      defaultMessage: 'Apply as range'
    })),
    checked: isRange,
    onChange: () => {
      if (isRange) {
        const newPointAnnotation = {
          type: 'manual',
          key: {
            type: 'point_in_time',
            timestamp: annotation.key.timestamp
          },
          id: annotation.id,
          label: annotation.label === _helpers.defaultRangeAnnotationLabel ? _helpers.defaultAnnotationLabel : annotation.label,
          color: (0, _helpers2.toLineAnnotationColor)(annotation.color),
          isHidden: annotation.isHidden
        };
        onChange(newPointAnnotation);
      } else if (annotation) {
        const fromTimestamp = (0, _moment.default)(annotation === null || annotation === void 0 ? void 0 : annotation.key.timestamp);
        const dataLayers = (0, _visualization_helpers.getDataLayers)(state.layers);
        const newRangeAnnotation = {
          type: 'manual',
          key: {
            type: 'range',
            timestamp: annotation.key.timestamp,
            endTimestamp: (0, _helpers2.getEndTimestamp)(datatableUtilities, fromTimestamp.toISOString(), frame, dataLayers)
          },
          id: annotation.id,
          label: annotation.label === _helpers.defaultAnnotationLabel ? _helpers.defaultRangeAnnotationLabel : annotation.label,
          color: (0, _helpers2.toRangeAnnotationColor)(annotation.color),
          isHidden: annotation.isHidden
        };
        onChange(newRangeAnnotation);
      }
    },
    compressed: true
  }));
};
exports.ConfigPanelApplyAsRangeSwitch = ConfigPanelApplyAsRangeSwitch;
const ConfigPanelRangeDatePicker = ({
  value,
  label,
  prependLabel,
  onChange,
  dataTestSubj = 'lnsXY_annotation_date_picker'
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    label: label,
    className: "lnsRowCompressedMargin"
  }, prependLabel ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    className: "lnsConfigPanelNoPadding",
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      className: "lnsConfigPanelDate__label"
    }, prependLabel)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    calendarClassName: _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    fullWidth: true,
    showTimeSelect: true,
    selected: value,
    onChange: onChange,
    dateFormat: "MMM D, YYYY @ HH:mm:ss.SSS",
    "data-test-subj": dataTestSubj
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    calendarClassName: _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    fullWidth: true,
    showTimeSelect: true,
    selected: value,
    onChange: onChange,
    dateFormat: "MMM D, YYYY @ HH:mm:ss.SSS",
    "data-test-subj": dataTestSubj
  }));
};
exports.ConfigPanelRangeDatePicker = ConfigPanelRangeDatePicker;