"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultQuery = exports.ConfigPanelQueryAnnotation = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/unified-field-list-plugin/public");
var _shared_components = require("../../../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultQuery = {
  query: '',
  language: 'kuery'
};
exports.defaultQuery = defaultQuery;
const ConfigPanelQueryAnnotation = ({
  annotation,
  frame,
  state,
  onChange,
  layer,
  queryInputShouldOpen
}) => {
  var _options$, _annotation$filter;
  const currentIndexPattern = frame.dataViews.indexPatterns[layer.indexPatternId];
  const {
    hasFieldData
  } = (0, _public.useExistingFieldsReader)();
  // list only date fields
  const options = currentIndexPattern.fields.filter(field => field.type === 'date' && field.displayName).map(field => {
    return {
      label: field.displayName,
      value: {
        type: 'field',
        field: field.name,
        dataType: field.type
      },
      exists: hasFieldData(currentIndexPattern.id, field.name),
      compatible: true,
      'data-test-subj': `lns-fieldOption-${field.name}`
    };
  });
  const selectedField = (annotation === null || annotation === void 0 ? void 0 : annotation.timeField) || currentIndexPattern.timeFieldName || ((_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.value.field);
  const fieldIsValid = selectedField ? Boolean(currentIndexPattern.getFieldByName(selectedField)) : true;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: true,
    display: "rowCompressed",
    className: "lnsRowCompressedMargin",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.annotation.queryInput', {
      defaultMessage: 'Annotation query'
    }),
    "data-test-subj": "annotation-query-based-query-input"
  }, /*#__PURE__*/_react.default.createElement(_shared_components.FilterQueryInput, {
    initiallyOpen: queryInputShouldOpen,
    label: "",
    inputFilter: (_annotation$filter = annotation === null || annotation === void 0 ? void 0 : annotation.filter) !== null && _annotation$filter !== void 0 ? _annotation$filter : defaultQuery,
    onChange: query => {
      onChange({
        filter: {
          type: 'kibana_query',
          ...query
        }
      });
    },
    "data-test-subj": "lnsXY-annotation-query-based-query-input",
    indexPattern: currentIndexPattern
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.annotation.queryField', {
      defaultMessage: 'Target date field'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_components.FieldPicker, {
    options: options,
    selectedOptions: selectedField ? [{
      label: selectedField,
      value: {
        type: 'field',
        field: selectedField
      }
    }] : [],
    onChoose: function (choice) {
      if (choice) {
        onChange({
          timeField: choice.field
        });
      }
    },
    fieldIsInvalid: !fieldIsValid,
    "data-test-subj": "lnsXY-annotation-query-based-field-picker"
  })));
};
exports.ConfigPanelQueryAnnotation = ConfigPanelQueryAnnotation;