"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toRangeAnnotationColor = exports.toLineAnnotationColor = exports.sanitizeProperties = exports.getEndTimestamp = void 0;
var _public = require("@kbn/data-plugin/public");
var _eui = require("@elastic/eui");
var _public2 = require("@kbn/event-annotation-plugin/public");
var _color = _interopRequireDefault(require("color"));
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toRangeAnnotationColor = (color = _public2.defaultAnnotationColor) => {
  return new _color.default((0, _eui.transparentize)(color, 0.1)).hexa();
};
exports.toRangeAnnotationColor = toRangeAnnotationColor;
const toLineAnnotationColor = (color = _public2.defaultAnnotationRangeColor) => {
  return new _color.default((0, _eui.transparentize)(color, 1)).hex();
};
exports.toLineAnnotationColor = toLineAnnotationColor;
const getEndTimestamp = (datatableUtilities, startTime, {
  activeData,
  dateRange
}, dataLayers) => {
  var _datatableUtilities$g;
  const startTimeNumber = (0, _moment.default)(startTime).valueOf();
  const dateRangeFraction = ((0, _moment.default)(dateRange.toDate).valueOf() - (0, _moment.default)(dateRange.fromDate).valueOf()) * 0.1;
  const fallbackValue = (0, _moment.default)(startTimeNumber + dateRangeFraction).toISOString();
  const dataLayersId = dataLayers.map(({
    layerId
  }) => layerId);
  if (!dataLayersId.length || !activeData || Object.entries(activeData).filter(([key]) => dataLayersId.includes(key)).every(([, {
    rows
  }]) => !rows || !rows.length)) {
    return fallbackValue;
  }
  const xColumn = activeData === null || activeData === void 0 ? void 0 : activeData[dataLayersId[0]].columns.find(column => column.id === dataLayers[0].xAccessor);
  if (!xColumn) {
    return fallbackValue;
  }
  const dateInterval = (_datatableUtilities$g = datatableUtilities.getDateHistogramMeta(xColumn)) === null || _datatableUtilities$g === void 0 ? void 0 : _datatableUtilities$g.interval;
  if (!dateInterval) return fallbackValue;
  const intervalDuration = _public.search.aggs.parseInterval(dateInterval);
  if (!intervalDuration) return fallbackValue;
  return (0, _moment.default)(startTimeNumber + 3 * intervalDuration.as('milliseconds')).toISOString();
};
exports.getEndTimestamp = getEndTimestamp;
const sanitizeProperties = annotation => {
  if ((0, _public2.isRangeAnnotationConfig)(annotation)) {
    const rangeAnnotation = (0, _lodash.pick)(annotation, ['type', 'label', 'key', 'id', 'isHidden', 'color', 'outside']);
    return rangeAnnotation;
  }
  if ((0, _public2.isQueryAnnotationConfig)(annotation)) {
    const lineAnnotation = (0, _lodash.pick)(annotation, ['type', 'id', 'label', 'key', 'timeField', 'isHidden', 'lineStyle', 'lineWidth', 'color', 'icon', 'textVisibility', 'textField', 'filter', 'extraFields']);
    return lineAnnotation;
  }
  const lineAnnotation = (0, _lodash.pick)(annotation, ['type', 'id', 'label', 'key', 'isHidden', 'lineStyle', 'lineWidth', 'color', 'icon', 'textVisibility']);
  return lineAnnotation;
};
exports.sanitizeProperties = sanitizeProperties;