"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./index.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/event-annotation-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _public2 = require("@kbn/unified-field-list-plugin/public");
var _field_picker = require("../../../../shared_components/field_picker");
var _shared_components = require("../../../../shared_components");
var _state_helpers = require("../../state_helpers");
var _helpers = require("../../annotations/helpers");
var _color_picker = require("../color_picker");
var _marker_decoration_settings = require("../shared/marker_decoration_settings");
var _line_style_settings = require("../shared/line_style_settings");
var _ = require("..");
var _icon_set = require("./icon_set");
var _manual_annotation_panel = require("./manual_annotation_panel");
var _query_annotation_panel = require("./query_annotation_panel");
var _tooltip_annotation_panel = require("./tooltip_annotation_panel");
var _helpers2 = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnnotationsPanel = props => {
  var _localLayer$annotatio;
  const {
    state,
    setState,
    layerId,
    accessor,
    frame
  } = props;
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  const {
    hasFieldData
  } = (0, _public2.useExistingFieldsReader)();
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _shared_components.useDebouncedValue)({
    value: state,
    onChange: setState
  });
  const index = localState.layers.findIndex(l => l.layerId === layerId);
  const localLayer = localState.layers.find(l => l.layerId === layerId);
  const currentAnnotation = (_localLayer$annotatio = localLayer.annotations) === null || _localLayer$annotatio === void 0 ? void 0 : _localLayer$annotatio.find(c => c.id === accessor);
  const isQueryBased = (0, _public.isQueryAnnotationConfig)(currentAnnotation);
  const isRange = (0, _public.isRangeAnnotationConfig)(currentAnnotation);
  const [queryInputShouldOpen, setQueryInputShouldOpen] = _react.default.useState(false);
  (0, _react.useEffect)(() => {
    setQueryInputShouldOpen(!isQueryBased);
  }, [isQueryBased]);
  const setAnnotations = (0, _react.useCallback)(annotation => {
    if (annotation == null) {
      return;
    }
    const newConfigs = [...(localLayer.annotations || [])];
    const existingIndex = newConfigs.findIndex(c => c.id === accessor);
    if (existingIndex !== -1) {
      const existingConfig = newConfigs[existingIndex];
      newConfigs[existingIndex] = (0, _helpers2.sanitizeProperties)({
        ...existingConfig,
        ...annotation
      });
    } else {
      throw new Error('should never happen because annotation is created before config panel is opened');
    }
    setLocalState((0, _.updateLayer)(localState, {
      ...localLayer,
      annotations: newConfigs
    }, index));
  }, [accessor, index, localState, localLayer, setLocalState]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_components.DimensionEditorSection, {
    title: _i18n.i18n.translate('xpack.lens.xyChart.placement', {
      defaultMessage: 'Placement'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.xyChart.annotationDate.placementType', {
      defaultMessage: 'Placement type'
    }),
    display: "rowCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.xyChart.annotationDate.placementType', {
      defaultMessage: 'Placement type'
    }),
    "data-test-subj": "lns-xyAnnotation-placementType",
    name: "placementType",
    buttonSize: "compressed",
    options: [{
      id: `lens_xyChart_annotation_manual`,
      label: _i18n.i18n.translate('xpack.lens.xyChart.annotation.manual', {
        defaultMessage: 'Static date'
      }),
      'data-test-subj': 'lnsXY_annotation_manual'
    }, {
      id: `lens_xyChart_annotation_query`,
      label: _i18n.i18n.translate('xpack.lens.xyChart.annotation.query', {
        defaultMessage: 'Custom query'
      }),
      'data-test-subj': 'lnsXY_annotation_query'
    }],
    idSelected: `lens_xyChart_annotation_${currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.type}`,
    onChange: id => {
      const typeFromId = id.replace('lens_xyChart_annotation_', '');
      if ((currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.type) === typeFromId) {
        return;
      }
      if (typeFromId === 'query') {
        var _ref, _currentIndexPattern$;
        const currentIndexPattern = frame.dataViews.indexPatterns[localLayer.indexPatternId];
        // If coming from a range type, it requires some additional resets
        const additionalRangeResets = (0, _public.isRangeAnnotationConfig)(currentAnnotation) ? {
          label: currentAnnotation.label === _helpers.defaultRangeAnnotationLabel ? _helpers.defaultAnnotationLabel : currentAnnotation.label,
          color: (0, _helpers2.toLineAnnotationColor)(currentAnnotation.color)
        } : {};
        return setAnnotations({
          type: typeFromId,
          timeField: (_ref = currentIndexPattern.timeFieldName || ( // fallback to the first avaiable date field in the dataView
          (_currentIndexPattern$ = currentIndexPattern.fields.find(({
            type: fieldType
          }) => fieldType === 'date')) === null || _currentIndexPattern$ === void 0 ? void 0 : _currentIndexPattern$.displayName)) !== null && _ref !== void 0 ? _ref : '',
          key: {
            type: 'point_in_time'
          },
          ...additionalRangeResets
        });
      }
      // From query to manual annotation
      return setAnnotations({
        type: typeFromId,
        key: {
          type: 'point_in_time',
          timestamp: (0, _moment.default)().toISOString()
        }
      });
    },
    isFullWidth: true
  })), isQueryBased ? /*#__PURE__*/_react.default.createElement(_query_annotation_panel.ConfigPanelQueryAnnotation, {
    annotation: currentAnnotation,
    onChange: setAnnotations,
    frame: frame,
    state: state,
    layer: localLayer,
    queryInputShouldOpen: queryInputShouldOpen
  }) : /*#__PURE__*/_react.default.createElement(_manual_annotation_panel.ConfigPanelManualAnnotation, {
    annotation: currentAnnotation,
    onChange: setAnnotations,
    datatableUtilities: props.datatableUtilities,
    frame: frame,
    state: state
  })), /*#__PURE__*/_react.default.createElement(_shared_components.DimensionEditorSection, {
    title: _i18n.i18n.translate('xpack.lens.xyChart.appearance', {
      defaultMessage: 'Appearance'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_components.NameInput, {
    value: (currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.label) || _helpers.defaultAnnotationLabel,
    defaultValue: _helpers.defaultAnnotationLabel,
    onChange: value => {
      setAnnotations({
        label: value
      });
    }
  }), !isRange && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_marker_decoration_settings.IconSelectSetting, {
    setConfig: setAnnotations,
    defaultIcon: "triangle",
    currentConfig: {
      axisMode: 'bottom',
      ...currentAnnotation
    },
    customIconSet: _icon_set.annotationsIconSet
  }), /*#__PURE__*/_react.default.createElement(_marker_decoration_settings.TextDecorationSetting, {
    setConfig: setAnnotations,
    currentConfig: {
      axisMode: 'bottom',
      ...currentAnnotation
    },
    isQueryBased: isQueryBased
  }, textDecorationSelected => {
    if (textDecorationSelected !== 'field') {
      return null;
    }
    const currentIndexPattern = frame.dataViews.indexPatterns[localLayer.indexPatternId];
    const options = currentIndexPattern.fields.filter(({
      displayName,
      type
    }) => displayName && type !== 'document').map(field => ({
      label: field.displayName,
      value: {
        type: 'field',
        field: field.name,
        dataType: field.type
      },
      exists: hasFieldData(currentIndexPattern.id, field.name),
      compatible: true,
      'data-test-subj': `lnsXY-annotation-fieldOption-${field.name}`
    }));
    const selectedField = currentAnnotation.textField;
    const fieldIsValid = selectedField ? Boolean(currentIndexPattern.getFieldByName(selectedField)) : true;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_field_picker.FieldPicker, {
      selectedOptions: selectedField ? [{
        label: selectedField,
        value: {
          type: 'field',
          field: selectedField
        }
      }] : [],
      options: options,
      onChoose: function (choice) {
        if (choice) {
          setAnnotations({
            textField: choice.field,
            textVisibility: true
          });
        }
      },
      fieldIsInvalid: !fieldIsValid,
      "data-test-subj": "lnsXY-annotation-query-based-text-decoration-field-picker",
      autoFocus: !selectedField
    }));
  }), /*#__PURE__*/_react.default.createElement(_line_style_settings.LineStyleSettings, {
    isHorizontal: isHorizontal,
    setConfig: setAnnotations,
    currentConfig: currentAnnotation
  })), isRange && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.xyChart.fillStyle', {
      defaultMessage: 'Fill'
    }),
    display: "columnCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.xyChart.fillStyle', {
      defaultMessage: 'Fill'
    }),
    "data-test-subj": "lns-xyAnnotation-fillStyle",
    name: "fillStyle",
    buttonSize: "compressed",
    options: [{
      id: `lens_xyChart_fillStyle_inside`,
      label: _i18n.i18n.translate('xpack.lens.xyChart.fillStyle.inside', {
        defaultMessage: 'Inside'
      }),
      'data-test-subj': 'lnsXY_fillStyle_inside'
    }, {
      id: `lens_xyChart_fillStyle_outside`,
      label: _i18n.i18n.translate('xpack.lens.xyChart.fillStyle.outside', {
        defaultMessage: 'Outside'
      }),
      'data-test-subj': 'lnsXY_fillStyle_inside'
    }],
    idSelected: `lens_xyChart_fillStyle_${Boolean(currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.outside) ? 'outside' : 'inside'}`,
    onChange: id => {
      setAnnotations({
        outside: id === `lens_xyChart_fillStyle_outside`
      });
    },
    isFullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, (0, _extends2.default)({}, props, {
    overwriteColor: currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.color,
    defaultColor: isRange ? _public.defaultAnnotationRangeColor : _public.defaultAnnotationColor,
    showAlpha: isRange,
    setConfig: setAnnotations,
    disableHelpTooltip: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineColor.label', {
      defaultMessage: 'Color'
    })
  })), /*#__PURE__*/_react.default.createElement(ConfigPanelGenericSwitch, {
    label: _i18n.i18n.translate('xpack.lens.xyChart.annotation.hide', {
      defaultMessage: 'Hide annotation'
    }),
    "data-test-subj": "lns-annotations-hide-annotation",
    value: Boolean(currentAnnotation === null || currentAnnotation === void 0 ? void 0 : currentAnnotation.isHidden),
    onChange: ev => setAnnotations({
      isHidden: ev.target.checked
    })
  })), isQueryBased && currentAnnotation && /*#__PURE__*/_react.default.createElement(_shared_components.DimensionEditorSection, {
    title: _i18n.i18n.translate('xpack.lens.xyChart.tooltip', {
      defaultMessage: 'Tooltip'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    className: "lnsRowCompressedMargin",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.annotation.tooltip', {
      defaultMessage: 'Show additional fields'
    })
  }, /*#__PURE__*/_react.default.createElement(_tooltip_annotation_panel.TooltipSection, {
    currentConfig: currentAnnotation,
    setConfig: setAnnotations,
    indexPattern: frame.dataViews.indexPatterns[localLayer.indexPatternId]
  }))));
};
exports.AnnotationsPanel = AnnotationsPanel;
const ConfigPanelGenericSwitch = ({
  label,
  ['data-test-subj']: dataTestSubj,
  value,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: label,
  display: "columnCompressedSwitch",
  fullWidth: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
  compressed: true,
  label: label,
  showLabel: false,
  "data-test-subj": dataTestSubj,
  checked: value,
  onChange: onChange
}));