"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettings = LayerSettings;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _visualization_helpers = require("./visualization_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerSettings({
  state,
  setState,
  section,
  layerId
}) {
  if (section === 'appearance') {
    return null;
  }
  const layer = state.layers.find(l => l.layerId === layerId);
  if (!layer || !(0, _visualization_helpers.isAnnotationsLayer)(layer)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressedSwitch",
    label: _i18n.i18n.translate('xpack.lens.xyChart.ignoreGlobalFilters', {
      defaultMessage: 'Use global filters'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.lens.xyChart.ignoreGlobalFilters', {
      defaultMessage: 'Use global filters'
    }),
    showLabel: false,
    checked: !layer.ignoreGlobalFilters,
    "data-test-subj": "lnsXY-layerSettings-ignoreGlobalFilters",
    onChange: () => {
      const layerIndex = state.layers.findIndex(l => l === layer);
      const newLayer = {
        ...layer,
        ignoreGlobalFilters: !layer.ignoreGlobalFilters
      };
      const newLayers = [...state.layers];
      newLayers[layerIndex] = newLayer;
      setState({
        ...state,
        layers: newLayers
      });
    },
    compressed: true
  }));
}