"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSingleColorAnnotationConfig = exports.getAnnotationsSupportedLayer = exports.getAnnotationsConfiguration = exports.getAnnotationsAccessorColorConfig = exports.defaultRangeAnnotationLabel = exports.defaultAnnotationLabel = void 0;
exports.getStaticDate = getStaticDate;
exports.setAnnotationsDimension = exports.onAnnotationDrop = exports.isDateHistogram = exports.getUniqueLabels = void 0;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/event-annotation-plugin/public");
var _chartIcons = require("@kbn/chart-icons");
var _public2 = require("@kbn/expression-xy-plugin/public");
var _utils = require("../../../utils");
var _state_helpers = require("../state_helpers");
var _icon_set = require("../xy_config_panel/annotations_config_panel/icon_set");
var _visualization_helpers = require("../visualization_helpers");
var _id_generator = require("../../../id_generator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_DATE = 8640000000000000;
const MIN_DATE = -8640000000000000;
const defaultAnnotationLabel = _i18n.i18n.translate('xpack.lens.xyChart.defaultAnnotationLabel', {
  defaultMessage: 'Event'
});
exports.defaultAnnotationLabel = defaultAnnotationLabel;
const defaultRangeAnnotationLabel = _i18n.i18n.translate('xpack.lens.xyChart.defaultRangeAnnotationLabel', {
  defaultMessage: 'Event range'
});
exports.defaultRangeAnnotationLabel = defaultRangeAnnotationLabel;
const isDateHistogram = (dataLayers, frame) => Boolean(dataLayers.length && dataLayers.every(dataLayer => dataLayer.xAccessor && (0, _visualization_helpers.checkScaleOperation)('interval', 'date', (frame === null || frame === void 0 ? void 0 : frame.datasourceLayers) || {})(dataLayer)));
exports.isDateHistogram = isDateHistogram;
function getStaticDate(dataLayers, frame) {
  const dataLayersId = dataLayers.map(({
    layerId
  }) => layerId);
  const {
    activeData,
    dateRange
  } = frame;
  const dateRangeMinValue = (0, _moment.default)(dateRange.fromDate).valueOf();
  const dateRangeMaxValue = (0, _moment.default)(dateRange.toDate).valueOf();
  const fallbackValue = (0, _moment.default)((dateRangeMinValue + dateRangeMaxValue) / 2).toISOString();
  if (!activeData || Object.entries(activeData).filter(([key]) => dataLayersId.includes(key)).every(([, {
    rows
  }]) => !rows || !rows.length)) {
    return fallbackValue;
  }
  const minDate = dataLayersId.reduce((acc, lId) => {
    var _dataLayers$find, _activeData$lId, _activeData$lId$rows, _activeData$lId$rows$;
    const xAccessor = (_dataLayers$find = dataLayers.find(dataLayer => dataLayer.layerId === lId)) === null || _dataLayers$find === void 0 ? void 0 : _dataLayers$find.xAccessor;
    const firstTimestamp = (_activeData$lId = activeData[lId]) === null || _activeData$lId === void 0 ? void 0 : (_activeData$lId$rows = _activeData$lId.rows) === null || _activeData$lId$rows === void 0 ? void 0 : (_activeData$lId$rows$ = _activeData$lId$rows[0]) === null || _activeData$lId$rows$ === void 0 ? void 0 : _activeData$lId$rows$[xAccessor];
    return firstTimestamp && firstTimestamp < acc ? firstTimestamp : acc;
  }, MAX_DATE);
  const maxDate = dataLayersId.reduce((acc, lId) => {
    var _dataLayers$find2, _activeData$lId2, _activeData$lId2$rows, _activeData$lId2$rows2, _activeData$lId3, _activeData$lId3$rows;
    const xAccessor = (_dataLayers$find2 = dataLayers.find(dataLayer => dataLayer.layerId === lId)) === null || _dataLayers$find2 === void 0 ? void 0 : _dataLayers$find2.xAccessor;
    const lastTimestamp = (_activeData$lId2 = activeData[lId]) === null || _activeData$lId2 === void 0 ? void 0 : (_activeData$lId2$rows = _activeData$lId2.rows) === null || _activeData$lId2$rows === void 0 ? void 0 : (_activeData$lId2$rows2 = _activeData$lId2$rows[(activeData === null || activeData === void 0 ? void 0 : (_activeData$lId3 = activeData[lId]) === null || _activeData$lId3 === void 0 ? void 0 : (_activeData$lId3$rows = _activeData$lId3.rows) === null || _activeData$lId3$rows === void 0 ? void 0 : _activeData$lId3$rows.length) - 1]) === null || _activeData$lId2$rows2 === void 0 ? void 0 : _activeData$lId2$rows2[xAccessor];
    return lastTimestamp && lastTimestamp > acc ? lastTimestamp : acc;
  }, MIN_DATE);
  const middleDate = (minDate + maxDate) / 2;
  if (dateRangeMinValue < middleDate && dateRangeMaxValue > middleDate) {
    return (0, _moment.default)(middleDate).toISOString();
  }
  return fallbackValue;
}
const getAnnotationsSupportedLayer = (state, frame) => {
  const dataLayers = (0, _visualization_helpers.getDataLayers)((state === null || state === void 0 ? void 0 : state.layers) || []);
  const hasDateHistogram = isDateHistogram(dataLayers, frame);
  const initialDimensions = state && hasDateHistogram ? [{
    groupId: 'xAnnotations',
    columnId: (0, _id_generator.generateId)()
  }] : undefined;
  return {
    type: _public2.LayerTypes.ANNOTATIONS,
    label: _i18n.i18n.translate('xpack.lens.xyChart.addAnnotationsLayerLabel', {
      defaultMessage: 'Annotations'
    }),
    icon: _chartIcons.IconChartBarAnnotations,
    disabled: !hasDateHistogram,
    toolTipContent: !hasDateHistogram ? _i18n.i18n.translate('xpack.lens.xyChart.addAnnotationsLayerLabelDisabledHelp', {
      defaultMessage: 'Annotations require a time based chart to work. Add a date histogram.'
    }) : undefined,
    initialDimensions,
    noDatasource: true
  };
};
exports.getAnnotationsSupportedLayer = getAnnotationsSupportedLayer;
const getDefaultManualAnnotation = (id, timestamp) => ({
  label: defaultAnnotationLabel,
  type: 'manual',
  key: {
    type: 'point_in_time',
    timestamp
  },
  icon: 'triangle',
  id
});
const getDefaultQueryAnnotation = (id, fieldName, timeField) => ({
  filter: {
    type: 'kibana_query',
    query: `${fieldName}: *`,
    language: 'kuery'
  },
  timeField,
  type: 'query',
  key: {
    type: 'point_in_time'
  },
  id,
  label: `${fieldName}: *`
});
const createCopiedAnnotation = (newId, timestamp, source) => {
  if (!source) {
    return getDefaultManualAnnotation(newId, timestamp);
  }
  return {
    ...source,
    id: newId
  };
};
const onAnnotationDrop = ({
  prevState,
  frame,
  source,
  target,
  dropType
}) => {
  const targetLayer = prevState.layers.find(l => l.layerId === target.layerId);
  if (!targetLayer || !(0, _visualization_helpers.isAnnotationsLayer)(targetLayer)) {
    return prevState;
  }
  const targetAnnotation = targetLayer.annotations.find(({
    id
  }) => id === target.columnId);
  const targetDataView = frame.dataViews.indexPatterns[targetLayer.indexPatternId];
  if ((0, _utils.isDraggedDataViewField)(source)) {
    const timeField = targetDataView.timeFieldName;
    switch (dropType) {
      case 'field_add':
        if (targetAnnotation || !timeField) {
          return prevState;
        }
        return {
          ...prevState,
          layers: prevState.layers.map(l => l.layerId === target.layerId ? {
            ...targetLayer,
            annotations: [...targetLayer.annotations, getDefaultQueryAnnotation(target.columnId, source.field.name, timeField)]
          } : l)
        };
      case 'field_replace':
        if (!targetAnnotation || !timeField) {
          return prevState;
        }
        return {
          ...prevState,
          layers: prevState.layers.map(l => l.layerId === target.layerId ? {
            ...targetLayer,
            annotations: [...targetLayer.annotations.map(a => a === targetAnnotation ? {
              ...targetAnnotation,
              ...getDefaultQueryAnnotation(target.columnId, source.field.name, timeField)
            } : a)]
          } : l)
        };
    }
    return prevState;
  }
  const sourceLayer = prevState.layers.find(l => l.layerId === source.layerId);
  if (!sourceLayer || !(0, _visualization_helpers.isAnnotationsLayer)(sourceLayer)) {
    return prevState;
  }
  const sourceAnnotation = sourceLayer.annotations.find(({
    id
  }) => id === source.columnId);
  const sourceDataView = frame.dataViews.indexPatterns[sourceLayer.indexPatternId];
  if (sourceDataView !== targetDataView && (0, _public.isQueryAnnotationConfig)(sourceAnnotation)) {
    return prevState;
  }
  switch (dropType) {
    case 'reorder':
      if (!targetAnnotation || !sourceAnnotation || source.layerId !== target.layerId) {
        return prevState;
      }
      const newAnnotations = targetLayer.annotations.filter(c => c.id !== sourceAnnotation.id);
      const targetPosition = newAnnotations.findIndex(c => c.id === targetAnnotation.id);
      const targetIndex = targetLayer.annotations.indexOf(sourceAnnotation);
      const sourceIndex = targetLayer.annotations.indexOf(targetAnnotation);
      newAnnotations.splice(targetIndex < sourceIndex ? targetPosition + 1 : targetPosition, 0, sourceAnnotation);
      return {
        ...prevState,
        layers: prevState.layers.map(l => l.layerId === target.layerId ? {
          ...targetLayer,
          annotations: newAnnotations
        } : l)
      };
    case 'swap_compatible':
      if (!targetAnnotation || !sourceAnnotation) {
        return prevState;
      }
      return {
        ...prevState,
        layers: prevState.layers.map(l => {
          if (!(0, _visualization_helpers.isAnnotationsLayer)(l) || !(0, _visualization_helpers.isAnnotationsLayer)(targetLayer)) {
            return l;
          }
          if (l.layerId === target.layerId) {
            return {
              ...targetLayer,
              annotations: [...targetLayer.annotations.map(a => a === targetAnnotation ? sourceAnnotation : a)]
            };
          }
          if (l.layerId === source.layerId) {
            return {
              ...sourceLayer,
              annotations: [...sourceLayer.annotations.map(a => a === sourceAnnotation ? targetAnnotation : a)]
            };
          }
          return l;
        })
      };
    case 'replace_compatible':
      if (!targetAnnotation || !sourceAnnotation) {
        return prevState;
      }
      return {
        ...prevState,
        layers: prevState.layers.map(l => {
          if (l.layerId === source.layerId) {
            return {
              ...sourceLayer,
              annotations: sourceLayer.annotations.filter(a => a !== sourceAnnotation)
            };
          }
          if (l.layerId === target.layerId) {
            return {
              ...targetLayer,
              annotations: [...targetLayer.annotations.map(a => a === targetAnnotation ? sourceAnnotation : a)]
            };
          }
          return l;
        })
      };
    case 'duplicate_compatible':
      if (targetAnnotation) {
        return prevState;
      }
      return {
        ...prevState,
        layers: prevState.layers.map(l => l.layerId === target.layerId ? {
          ...targetLayer,
          annotations: [...targetLayer.annotations, createCopiedAnnotation(target.columnId, getStaticDate((0, _visualization_helpers.getDataLayers)(prevState.layers), frame), sourceAnnotation)]
        } : l)
      };
    case 'replace_duplicate_compatible':
      if (!targetAnnotation) {
        return prevState;
      }
      return {
        ...prevState,
        layers: prevState.layers.map(l => {
          if (l.layerId === target.layerId) {
            return {
              ...targetLayer,
              annotations: [...targetLayer.annotations.map(a => a === targetAnnotation ? createCopiedAnnotation(target.columnId, getStaticDate((0, _visualization_helpers.getDataLayers)(prevState.layers), frame), sourceAnnotation) : a)]
            };
          }
          return l;
        })
      };
    case 'move_compatible':
      if (targetAnnotation || !sourceAnnotation) {
        return prevState;
      }
      return {
        ...prevState,
        layers: prevState.layers.map(l => {
          if (l.layerId === source.layerId) {
            return {
              ...sourceLayer,
              annotations: sourceLayer.annotations.filter(a => a !== sourceAnnotation)
            };
          }
          if (l.layerId === target.layerId) {
            return {
              ...targetLayer,
              annotations: [...targetLayer.annotations, sourceAnnotation]
            };
          }
          return l;
        })
      };
    default:
      return prevState;
  }
  return prevState;
};
exports.onAnnotationDrop = onAnnotationDrop;
const setAnnotationsDimension = ({
  prevState,
  layerId,
  columnId,
  previousColumn,
  frame
}) => {
  var _targetLayer$annotati;
  const targetLayer = prevState.layers.find(l => l.layerId === layerId);
  if (!targetLayer || !(0, _visualization_helpers.isAnnotationsLayer)(targetLayer)) {
    return prevState;
  }
  const sourceAnnotation = previousColumn ? (_targetLayer$annotati = targetLayer.annotations) === null || _targetLayer$annotati === void 0 ? void 0 : _targetLayer$annotati.find(({
    id
  }) => id === previousColumn) : undefined;
  return {
    ...prevState,
    layers: prevState.layers.map(l => l.layerId === layerId ? {
      ...targetLayer,
      annotations: [...targetLayer.annotations, createCopiedAnnotation(columnId, getStaticDate((0, _visualization_helpers.getDataLayers)(prevState.layers), frame), sourceAnnotation)]
    } : l)
  };
};
exports.setAnnotationsDimension = setAnnotationsDimension;
const getSingleColorAnnotationConfig = annotation => {
  var _annotationIcon$icon;
  const annotationIcon = !(0, _public.isRangeAnnotationConfig)(annotation) ? _icon_set.annotationsIconSet.find(option => option.value === (annotation === null || annotation === void 0 ? void 0 : annotation.icon)) || _icon_set.annotationsIconSet.find(option => option.value === 'triangle') : undefined;
  const icon = (_annotationIcon$icon = annotationIcon === null || annotationIcon === void 0 ? void 0 : annotationIcon.icon) !== null && _annotationIcon$icon !== void 0 ? _annotationIcon$icon : annotationIcon === null || annotationIcon === void 0 ? void 0 : annotationIcon.value;
  return {
    columnId: annotation.id,
    triggerIconType: annotation.isHidden ? 'invisible' : icon ? 'custom' : 'color',
    customIcon: icon,
    color: (annotation === null || annotation === void 0 ? void 0 : annotation.color) || ((0, _public.isRangeAnnotationConfig)(annotation) ? _public.defaultAnnotationRangeColor : _public.defaultAnnotationColor)
  };
};
exports.getSingleColorAnnotationConfig = getSingleColorAnnotationConfig;
const getAnnotationsAccessorColorConfig = layer => layer.annotations.map(annotation => getSingleColorAnnotationConfig(annotation));
exports.getAnnotationsAccessorColorConfig = getAnnotationsAccessorColorConfig;
const getAnnotationsConfiguration = ({
  state,
  frame,
  layer
}) => {
  const groupLabel = (0, _visualization_helpers.getAxisName)('x', {
    isHorizontal: (0, _state_helpers.isHorizontalChart)(state.layers)
  });
  const emptyButtonLabels = {
    buttonAriaLabel: _i18n.i18n.translate('xpack.lens.indexPattern.addColumnAriaLabelClick', {
      defaultMessage: 'Add an annotation to {groupLabel}',
      values: {
        groupLabel
      }
    }),
    buttonLabel: _i18n.i18n.translate('xpack.lens.configure.emptyConfigClick', {
      defaultMessage: 'Add an annotation'
    })
  };
  return {
    groups: [{
      groupId: 'xAnnotations',
      groupLabel,
      dimensionEditorGroupLabel: _i18n.i18n.translate('xpack.lens.indexPattern.annotationsDimensionEditorLabel', {
        defaultMessage: '{groupLabel} annotation',
        values: {
          groupLabel
        }
      }),
      accessors: getAnnotationsAccessorColorConfig(layer),
      dataTestSubj: 'lnsXY_xAnnotationsPanel',
      requiredMinDimensionCount: 0,
      supportsMoreColumns: true,
      supportFieldFormat: false,
      enableDimensionEditor: true,
      filterOperations: () => false,
      labels: emptyButtonLabels
    }]
  };
};
exports.getAnnotationsConfiguration = getAnnotationsConfiguration;
const getUniqueLabels = layers => {
  const annotationLayers = (0, _visualization_helpers.getAnnotationsLayers)(layers);
  const columnLabelMap = {};
  const counts = {};
  const makeUnique = label => {
    let uniqueLabel = label;
    while (counts[uniqueLabel] >= 0) {
      const num = ++counts[uniqueLabel];
      uniqueLabel = _i18n.i18n.translate('xpack.lens.uniqueLabel', {
        defaultMessage: '{label} [{num}]',
        values: {
          label,
          num
        }
      });
    }
    counts[uniqueLabel] = 0;
    return uniqueLabel;
  };
  annotationLayers.forEach(layer => {
    if (!layer.annotations) {
      return;
    }
    layer.annotations.forEach(l => {
      columnLabelMap[l.id] = makeUnique(l.label);
    });
  });
  return columnLabelMap;
};
exports.getUniqueLabels = getUniqueLabels;