"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapToolbar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/visualizations-plugin/public");
var _chartIcons = require("@kbn/chart-icons");
var _shared_components = require("../../shared_components");
var _datasource_default_values = require("../../shared_components/datasource_default_values");
require("./toolbar_component.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const legendOptions = [{
  id: `heatmap_legend_show`,
  value: 'show',
  label: _i18n.i18n.translate('xpack.lens.heatmapChart.legendVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: `heatmap_legend_hide`,
  value: 'hide',
  label: _i18n.i18n.translate('xpack.lens.heatmapChart.legendVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];
const HeatmapToolbar = /*#__PURE__*/(0, _react.memo)(props => {
  var _state$legend$shouldT;
  const {
    state,
    setState,
    frame
  } = props;
  const legendMode = state.legend.isVisible ? 'show' : 'hide';
  const defaultTruncationValue = (0, _datasource_default_values.getDefaultVisualValuesForLayer)(state, frame.datasourceLayers).truncateText;
  const legendSize = state === null || state === void 0 ? void 0 : state.legend.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _public.LegendSize.AUTO);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.shared.curveLabel', {
      defaultMessage: 'Visual options'
    }),
    type: "visualOptions",
    groupPosition: "left",
    buttonDataTestSubj: "lnsVisualOptionsButton"
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ValueLabelsSettings, {
    valueLabels: state !== null && state !== void 0 && state.gridConfig.isCellLabelVisible ? 'show' : 'hide',
    onValueLabelChange: newMode => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isCellLabelVisible: newMode === 'show'
        }
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_components.LegendSettingsPopover, {
    groupPosition: 'right',
    legendOptions: legendOptions,
    mode: legendMode,
    onDisplayChange: optionId => {
      const newMode = legendOptions.find(({
        id
      }) => id === optionId).value;
      if (newMode === 'show') {
        setState({
          ...state,
          legend: {
            ...state.legend,
            isVisible: true
          }
        });
      } else if (newMode === 'hide') {
        setState({
          ...state,
          legend: {
            ...state.legend,
            isVisible: false
          }
        });
      }
    },
    position: state === null || state === void 0 ? void 0 : state.legend.position,
    onPositionChange: id => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          position: id
        }
      });
    },
    maxLines: state === null || state === void 0 ? void 0 : state.legend.maxLines,
    onMaxLinesChange: val => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          maxLines: val
        }
      });
    },
    shouldTruncate: (_state$legend$shouldT = state === null || state === void 0 ? void 0 : state.legend.shouldTruncate) !== null && _state$legend$shouldT !== void 0 ? _state$legend$shouldT : defaultTruncationValue,
    onTruncateLegendChange: () => {
      var _state$legend$shouldT2;
      const current = (_state$legend$shouldT2 = state.legend.shouldTruncate) !== null && _state$legend$shouldT2 !== void 0 ? _state$legend$shouldT2 : defaultTruncationValue;
      setState({
        ...state,
        legend: {
          ...state.legend,
          shouldTruncate: !current
        }
      });
    },
    legendSize: legendSize,
    onLegendSizeChange: newLegendSize => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          legendSize: newLegendSize
        }
      });
    },
    showAutoLegendSizeOption: hadAutoLegendSize
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_shared_components.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('xpack.lens.heatmap.verticalAxisDisabledHelpText', {
      defaultMessage: 'This setting only applies when vertical axis is enabled.'
    }),
    condition: !Boolean(state === null || state === void 0 ? void 0 : state.yAccessor)
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.heatmap.verticalAxisLabel', {
      defaultMessage: 'Vertical axis'
    }),
    type: _chartIcons.EuiIconAxisLeft,
    groupPosition: "left",
    isDisabled: !Boolean(state === null || state === void 0 ? void 0 : state.yAccessor),
    buttonDataTestSubj: "lnsHeatmapVerticalAxisButton",
    panelClassName: "lnsVisToolbarAxis__popover"
  }, /*#__PURE__*/_react.default.createElement(_shared_components.AxisTitleSettings, {
    axis: "yLeft",
    axisTitle: state === null || state === void 0 ? void 0 : state.gridConfig.yTitle,
    updateTitleState: ({
      title,
      visible
    }) => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          yTitle: title,
          isYAxisTitleVisible: visible
        }
      });
    },
    isAxisTitleVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isYAxisTitleVisible
  }), /*#__PURE__*/_react.default.createElement(_shared_components.AxisTicksSettings, {
    axis: "yLeft",
    updateTicksVisibilityState: visible => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isYAxisLabelVisible: visible
        }
      });
    },
    isAxisLabelVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isYAxisLabelVisible
  }))), /*#__PURE__*/_react.default.createElement(_shared_components.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('xpack.lens.heatmap.horizontalAxisDisabledHelpText', {
      defaultMessage: 'This setting only applies when horizontal axis is enabled.'
    }),
    condition: !Boolean(state === null || state === void 0 ? void 0 : state.xAccessor)
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.heatmap.horizontalAxisLabel', {
      defaultMessage: 'Horizontal axis'
    }),
    type: _chartIcons.EuiIconAxisBottom,
    groupPosition: "center",
    isDisabled: !Boolean(state === null || state === void 0 ? void 0 : state.xAccessor),
    buttonDataTestSubj: "lnsHeatmapHorizontalAxisButton"
  }, /*#__PURE__*/_react.default.createElement(_shared_components.AxisTitleSettings, {
    axis: "x",
    axisTitle: state === null || state === void 0 ? void 0 : state.gridConfig.xTitle,
    updateTitleState: ({
      title,
      visible
    }) => setState({
      ...state,
      gridConfig: {
        ...state.gridConfig,
        xTitle: title,
        isXAxisTitleVisible: visible
      }
    }),
    isAxisTitleVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isXAxisTitleVisible
  }), /*#__PURE__*/_react.default.createElement(_shared_components.AxisTicksSettings, {
    axis: "x",
    updateTicksVisibilityState: visible => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isXAxisLabelVisible: visible
        }
      });
    },
    isAxisLabelVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isXAxisLabelVisible
  }))))));
});
exports.HeatmapToolbar = HeatmapToolbar;