"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LENS_HEATMAP_RENDERER = exports.LENS_HEATMAP_ID = exports.LEGEND_FUNCTION = exports.HEATMAP_GRID_FUNCTION = exports.GROUP_ID = exports.FUNCTION_NAME = exports.DEFAULT_PALETTE_NAME = exports.CHART_SHAPES = exports.CHART_NAMES = void 0;
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LENS_HEATMAP_RENDERER = 'lens_heatmap_renderer';
exports.LENS_HEATMAP_RENDERER = LENS_HEATMAP_RENDERER;
const LENS_HEATMAP_ID = 'lnsHeatmap';
exports.LENS_HEATMAP_ID = LENS_HEATMAP_ID;
const DEFAULT_PALETTE_NAME = 'temperature';
exports.DEFAULT_PALETTE_NAME = DEFAULT_PALETTE_NAME;
const groupLabel = _i18n.i18n.translate('xpack.lens.heatmap.groupLabel', {
  defaultMessage: 'Heatmap'
});
const CHART_SHAPES = {
  HEATMAP: 'heatmap'
};
exports.CHART_SHAPES = CHART_SHAPES;
const CHART_NAMES = {
  heatmap: {
    shapeType: CHART_SHAPES.HEATMAP,
    icon: _chartIcons.IconChartHeatmap,
    label: _i18n.i18n.translate('xpack.lens.heatmap.heatmapLabel', {
      defaultMessage: 'Heat map'
    }),
    groupLabel
  }
};
exports.CHART_NAMES = CHART_NAMES;
const GROUP_ID = {
  X: 'x',
  Y: 'y',
  CELL: 'cell'
};
exports.GROUP_ID = GROUP_ID;
const FUNCTION_NAME = 'heatmap';
exports.FUNCTION_NAME = FUNCTION_NAME;
const LEGEND_FUNCTION = 'heatmap_legend';
exports.LEGEND_FUNCTION = LEGEND_FUNCTION;
const HEATMAP_GRID_FUNCTION = 'heatmap_grid';
exports.HEATMAP_GRID_FUNCTION = HEATMAP_GRID_FUNCTION;