"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transparentizePalettes = exports.defaultPaletteParams = exports.DEFAULT_PALETTE_NAME = exports.DEFAULT_MIN_STOP = exports.DEFAULT_MAX_STOP = exports.DEFAULT_COLOR_STEPS = void 0;
var _color = _interopRequireDefault(require("color"));
var _shared_components = require("../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PALETTE_NAME = 'gray';
exports.DEFAULT_PALETTE_NAME = DEFAULT_PALETTE_NAME;
const DEFAULT_COLOR_STEPS = 3;
exports.DEFAULT_COLOR_STEPS = DEFAULT_COLOR_STEPS;
const DEFAULT_MIN_STOP = 0;
exports.DEFAULT_MIN_STOP = DEFAULT_MIN_STOP;
const DEFAULT_MAX_STOP = 100;
exports.DEFAULT_MAX_STOP = DEFAULT_MAX_STOP;
const defaultPaletteParams = {
  ..._shared_components.defaultPaletteParams,
  rangeMin: DEFAULT_MIN_STOP,
  rangeMax: DEFAULT_MAX_STOP,
  name: DEFAULT_PALETTE_NAME,
  steps: DEFAULT_COLOR_STEPS,
  maxSteps: 5
};
exports.defaultPaletteParams = defaultPaletteParams;
const transparentizePalettes = palettes => {
  const addAlpha = c => c ? new _color.default(c).hex() + `80` : `000000`;
  const transparentizePalette = palette => ({
    ...palette,
    getCategoricalColor: (series, chartConfiguration, state) => addAlpha(palette.getCategoricalColor(series, chartConfiguration, state)),
    getCategoricalColors: (size, state) => palette.getCategoricalColors(size, state).map(addAlpha)
  });
  return {
    ...palettes,
    get: name => transparentizePalette(palettes.get(name)),
    getAll: () => palettes.getAll().map(singlePalette => transparentizePalette(singlePalette))
  };
};
exports.transparentizePalettes = transparentizePalettes;