"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GaugeVisualization = void 0;
var _palette_config = require("./palette_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class GaugeVisualization {
  setup(core, {
    editorFrame,
    charts
  }) {
    editorFrame.registerVisualization(async () => {
      const {
        getGaugeVisualization
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
      const palettes = (0, _palette_config.transparentizePalettes)(await charts.palettes.getPalettes());
      return getGaugeVisualization({
        paletteService: palettes,
        theme: core.theme
      });
    });
  }
}
exports.GaugeVisualization = GaugeVisualization;