"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTableToolbar = DataTableToolbar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_components = require("../../../shared_components");
var _row_height_settings = require("./row_height_settings");
var _table_basic = require("./table_basic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataTableToolbar(props) {
  var _state$paging2;
  const {
    state,
    setState
  } = props;
  const onChangeHeight = (0, _react.useCallback)((newHeightMode, heightProperty, heightLinesProperty) => {
    const rowHeightLines = newHeightMode === 'single' ? 1 : newHeightMode !== 'auto' ? 2 : undefined;
    setState({
      ...state,
      [heightProperty]: newHeightMode,
      [heightLinesProperty]: rowHeightLines
    });
  }, [setState, state]);
  const onChangeHeightLines = (0, _react.useCallback)((newRowHeightLines, heightLinesProperty) => {
    setState({
      ...state,
      [heightLinesProperty]: newRowHeightLines
    });
  }, [setState, state]);
  const onTogglePagination = (0, _react.useCallback)(() => {
    var _state$paging;
    const current = (_state$paging = state.paging) !== null && _state$paging !== void 0 ? _state$paging : {
      size: _table_basic.DEFAULT_PAGE_SIZE,
      enabled: false
    };
    setState({
      ...state,
      paging: {
        ...current,
        enabled: !current.enabled
      }
    });
  }, [setState, state]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.table.valuesVisualOptions', {
      defaultMessage: 'Visual options'
    }),
    type: "visualOptions",
    groupPosition: "none",
    buttonDataTestSubj: "lnsVisualOptionsButton"
  }, /*#__PURE__*/_react.default.createElement(_row_height_settings.RowHeightSettings, {
    rowHeight: state.headerRowHeight,
    rowHeightLines: state.headerRowHeightLines,
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsHeaderRowHeightLabel', {
      defaultMessage: 'Header row height'
    }),
    onChangeRowHeight: mode => onChangeHeight(mode, 'headerRowHeight', 'headerRowHeightLines'),
    onChangeRowHeightLines: lines => {
      onChangeHeightLines(lines, 'headerRowHeightLines');
    },
    "data-test-subj": "lnsHeaderHeightSettings",
    maxRowHeight: 5
  }), /*#__PURE__*/_react.default.createElement(_row_height_settings.RowHeightSettings, {
    rowHeight: state.rowHeight,
    rowHeightLines: state.rowHeightLines,
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsFitRowToContentLabel', {
      defaultMessage: 'Cell row height'
    }),
    onChangeRowHeight: mode => onChangeHeight(mode, 'rowHeight', 'rowHeightLines'),
    onChangeRowHeightLines: lines => {
      onChangeHeightLines(lines, 'rowHeightLines');
    },
    "data-test-subj": "lnsRowHeightSettings"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.table.visualOptionsPaginateTable', {
      defaultMessage: 'Paginate table'
    }),
    display: "columnCompressedSwitch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.lens.table.visualOptionsPaginateTableTooltip', {
      defaultMessage: 'Pagination is hidden if there are less than 10 items'
    }),
    position: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    "data-test-subj": "lens-table-pagination-switch",
    label: "",
    showLabel: false,
    checked: Boolean((_state$paging2 = state.paging) === null || _state$paging2 === void 0 ? void 0 : _state$paging2.enabled),
    onChange: onTogglePagination
  })))));
}