"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableDimensionDataExtraEditor = TableDimensionDataExtraEditor;
exports.TableDimensionEditor = TableDimensionEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _shared_components = require("../../../shared_components");
var _utils = require("../../../../common/expressions/datatable/utils");
var _transpose_helpers = require("../../../../common/expressions/datatable/transpose_helpers");
require("./dimension_editor.scss");
var _collapse_setting = require("../../../shared_components/collapse_setting");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const idPrefix = (0, _eui.htmlIdGenerator)()();
function updateColumnWith(state, columnId, newColumnProps) {
  return state.columns.map(currentColumn => {
    if (currentColumn.columnId === columnId) {
      return {
        ...currentColumn,
        ...newColumnProps
      };
    } else {
      return currentColumn;
    }
  });
}
function TableDimensionEditor(props) {
  var _frame$activeData, _datasource$getOperat;
  const {
    state,
    setState,
    frame,
    accessor
  } = props;
  const column = state.columns.find(({
    columnId
  }) => accessor === columnId);
  const [isPaletteOpen, setIsPaletteOpen] = (0, _react.useState)(false);
  if (!column) return null;
  if (column.isTransposed) return null;
  const currentData = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId];

  // either read config state or use same logic as chart itself
  const isNumeric = (0, _utils.isNumericFieldForDatatable)(currentData, accessor);
  const currentAlignment = (column === null || column === void 0 ? void 0 : column.alignment) || (isNumeric ? 'right' : 'left');
  const currentColorMode = (column === null || column === void 0 ? void 0 : column.colorMode) || 'none';
  const hasDynamicColoring = currentColorMode !== 'none';
  const datasource = frame.datasourceLayers[state.layerId];
  const showDynamicColoringFeature = Boolean(isNumeric && !(datasource !== null && datasource !== void 0 && (_datasource$getOperat = datasource.getOperationForColumnId(accessor)) !== null && _datasource$getOperat !== void 0 && _datasource$getOperat.isBucketed));
  const visibleColumnsCount = state.columns.filter(c => !c.hidden).length;
  const hasTransposedColumn = state.columns.some(({
    isTransposed
  }) => isTransposed);
  const columnsToCheck = hasTransposedColumn ? (currentData === null || currentData === void 0 ? void 0 : currentData.columns.filter(({
    id
  }) => (0, _transpose_helpers.getOriginalId)(id) === accessor).map(({
    id
  }) => id)) || [] : [accessor];
  const minMaxByColumnId = (0, _shared_components.findMinMaxByColumnId)(columnsToCheck, currentData, _transpose_helpers.getOriginalId);
  const currentMinMax = minMaxByColumnId[accessor];
  const activePalette = (column === null || column === void 0 ? void 0 : column.palette) || {
    type: 'palette',
    name: _shared_components.defaultPaletteParams.name
  };
  // need to tell the helper that the colorStops are required to display
  const displayStops = (0, _shared_components.applyPaletteParams)(props.paletteService, activePalette, currentMinMax);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.alignment.label', {
      defaultMessage: 'Text alignment'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.table.alignment.label', {
      defaultMessage: 'Text alignment'
    }),
    "data-test-subj": "lnsDatatable_alignment_groups",
    name: "alignment",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}left`,
      label: _i18n.i18n.translate('xpack.lens.table.alignment.left', {
        defaultMessage: 'Left'
      }),
      'data-test-subj': 'lnsDatatable_alignment_groups_left'
    }, {
      id: `${idPrefix}center`,
      label: _i18n.i18n.translate('xpack.lens.table.alignment.center', {
        defaultMessage: 'Center'
      }),
      'data-test-subj': 'lnsDatatable_alignment_groups_center'
    }, {
      id: `${idPrefix}right`,
      label: _i18n.i18n.translate('xpack.lens.table.alignment.right', {
        defaultMessage: 'Right'
      }),
      'data-test-subj': 'lnsDatatable_alignment_groups_right'
    }],
    idSelected: `${idPrefix}${currentAlignment}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setState({
        ...state,
        columns: updateColumnWith(state, accessor, {
          alignment: newMode
        })
      });
    }
  })), showDynamicColoringFeature && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.label', {
      defaultMessage: 'Color by value'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.label', {
      defaultMessage: 'Color by value'
    }),
    "data-test-subj": "lnsDatatable_dynamicColoring_groups",
    name: "dynamicColoring",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}none`,
      label: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.none', {
        defaultMessage: 'None'
      }),
      'data-test-subj': 'lnsDatatable_dynamicColoring_groups_none'
    }, {
      id: `${idPrefix}cell`,
      label: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.cell', {
        defaultMessage: 'Cell'
      }),
      'data-test-subj': 'lnsDatatable_dynamicColoring_groups_cell'
    }, {
      id: `${idPrefix}text`,
      label: _i18n.i18n.translate('xpack.lens.table.dynamicColoring.text', {
        defaultMessage: 'Text'
      }),
      'data-test-subj': 'lnsDatatable_dynamicColoring_groups_text'
    }],
    idSelected: `${idPrefix}${currentColorMode}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      const params = {
        colorMode: newMode
      };
      if (!(column !== null && column !== void 0 && column.palette) && newMode !== 'none') {
        params.palette = {
          ...activePalette,
          params: {
            ...activePalette.params,
            // that's ok, at first open we're going to throw them away and recompute
            stops: displayStops
          }
        };
      }
      // clear up when switching to no coloring
      if (column !== null && column !== void 0 && column.palette && newMode === 'none') {
        params.palette = undefined;
      }
      setState({
        ...state,
        columns: updateColumnWith(state, accessor, params)
      });
    }
  })), hasDynamicColoring && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "lnsDynamicColoringRow",
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.paletteTableGradient.label', {
      defaultMessage: 'Color'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    className: "lnsDynamicColoringClickable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
    "data-test-subj": "lnsDatatable_dynamicColoring_palette",
    palette: displayStops.map(({
      color
    }) => color),
    type: _coloring.FIXED_PROGRESSION,
    onClick: () => {
      setIsPaletteOpen(!isPaletteOpen);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "lnsDatatable_dynamicColoring_trigger",
    iconType: "controlsHorizontal",
    onClick: () => {
      setIsPaletteOpen(!isPaletteOpen);
    },
    size: "xs",
    flush: "both"
  }, _i18n.i18n.translate('xpack.lens.paletteTableGradient.customize', {
    defaultMessage: 'Edit'
  })), /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
    siblingRef: props.panelRef,
    isOpen: isPaletteOpen,
    handleClose: () => setIsPaletteOpen(!isPaletteOpen)
  }, /*#__PURE__*/_react.default.createElement(_coloring.CustomizablePalette, {
    palettes: props.paletteService,
    activePalette: activePalette,
    dataBounds: currentMinMax,
    setPalette: newPalette => {
      setState({
        ...state,
        columns: updateColumnWith(state, accessor, {
          palette: newPalette
        })
      });
    }
  })))))), !column.isTransposed && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.columnVisibilityLabel', {
      defaultMessage: 'Hide column'
    }),
    display: "columnCompressedSwitch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.table.columnVisibilityLabel', {
      defaultMessage: 'Hide column'
    }),
    showLabel: false,
    "data-test-subj": "lns-table-column-hidden",
    checked: Boolean(column === null || column === void 0 ? void 0 : column.hidden),
    disabled: !column.hidden && visibleColumnsCount <= 1,
    onChange: () => {
      const newState = {
        ...state,
        columns: state.columns.map(currentColumn => {
          if (currentColumn.columnId === accessor) {
            return {
              ...currentColumn,
              hidden: !column.hidden
            };
          } else {
            return currentColumn;
          }
        })
      };
      setState(newState);
    }
  })), props.groupId === 'rows' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.table.columnFilterClickLabel', {
      defaultMessage: 'Directly filter on click'
    }),
    display: "columnCompressedSwitch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.table.columnFilterClickLabel', {
      defaultMessage: 'Directly filter on click'
    }),
    showLabel: false,
    "data-test-subj": "lns-table-column-one-click-filter",
    checked: Boolean(column === null || column === void 0 ? void 0 : column.oneClickFilter),
    disabled: column.hidden,
    onChange: () => {
      const newState = {
        ...state,
        columns: state.columns.map(currentColumn => {
          if (currentColumn.columnId === accessor) {
            return {
              ...currentColumn,
              oneClickFilter: !column.oneClickFilter
            };
          } else {
            return currentColumn;
          }
        })
      };
      setState(newState);
    }
  })));
}
function TableDimensionDataExtraEditor(props) {
  const {
    state,
    setState,
    accessor
  } = props;
  const column = state.columns.find(({
    columnId
  }) => accessor === columnId);
  if (!column) return null;
  if (column.isTransposed) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, props.groupId === 'rows' && /*#__PURE__*/_react.default.createElement(_collapse_setting.CollapseSetting, {
    value: column.collapseFn || '',
    onChange: collapseFn => {
      setState({
        ...state,
        columns: updateColumnWith(state, accessor, {
          collapseFn
        })
      });
    }
  }));
}