"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGridColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGridColumns = (bucketColumns, table, handleFilterClick, handleTransposedColumnClick, isReadOnly, columnConfig, visibleColumns, formatFactory, onColumnResize, onColumnHide, alignments, headerRowHeight, headerRowLines, columnCellValueActions, closeCellPopover, columnFilterable) => {
  const columnsReverseLookup = table.columns.reduce((memo, {
    id,
    name,
    meta
  }, i) => {
    memo[id] = {
      name,
      index: i,
      meta
    };
    return memo;
  }, {});
  const getContentData = ({
    rowIndex,
    columnId
  }) => {
    var _table$rows$rowIndex, _column$meta;
    // incoming data might change and put the current page out of bounds - check whether row actually exists
    const rowValue = (_table$rows$rowIndex = table.rows[rowIndex]) === null || _table$rows$rowIndex === void 0 ? void 0 : _table$rows$rowIndex[columnId];
    const column = columnsReverseLookup === null || columnsReverseLookup === void 0 ? void 0 : columnsReverseLookup[columnId];
    const contentsIsDefined = rowValue != null;
    const cellContent = formatFactory(column === null || column === void 0 ? void 0 : (_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.params).convert(rowValue);
    return {
      rowValue,
      contentsIsDefined,
      cellContent
    };
  };
  return visibleColumns.map(field => {
    var _columnCellValueActio;
    const {
      name,
      index: colIndex
    } = columnsReverseLookup[field];
    const filterable = (columnFilterable === null || columnFilterable === void 0 ? void 0 : columnFilterable[colIndex]) || false;
    const columnArgs = columnConfig.columns.find(({
      columnId
    }) => columnId === field);
    const cellActions = [];
    if (filterable && handleFilterClick && !(columnArgs !== null && columnArgs !== void 0 && columnArgs.oneClickFilter)) {
      cellActions.push(({
        rowIndex,
        columnId,
        Component
      }) => {
        const {
          rowValue,
          contentsIsDefined,
          cellContent
        } = getContentData({
          rowIndex,
          columnId
        });
        const filterForText = _i18n.i18n.translate('xpack.lens.table.tableCellFilter.filterForValueText', {
          defaultMessage: 'Filter for value'
        });
        const filterForAriaLabel = _i18n.i18n.translate('xpack.lens.table.tableCellFilter.filterForValueAriaLabel', {
          defaultMessage: 'Filter for value: {cellContent}',
          values: {
            cellContent
          }
        });
        return contentsIsDefined && /*#__PURE__*/_react.default.createElement(Component, {
          "aria-label": filterForAriaLabel,
          "data-test-subj": "lensDatatableFilterFor",
          onClick: () => {
            handleFilterClick(field, rowValue, colIndex, rowIndex);
            closeCellPopover === null || closeCellPopover === void 0 ? void 0 : closeCellPopover();
          },
          iconType: "plusInCircle"
        }, filterForText);
      }, ({
        rowIndex,
        columnId,
        Component
      }) => {
        const {
          rowValue,
          contentsIsDefined,
          cellContent
        } = getContentData({
          rowIndex,
          columnId
        });
        const filterOutText = _i18n.i18n.translate('xpack.lens.table.tableCellFilter.filterOutValueText', {
          defaultMessage: 'Filter out value'
        });
        const filterOutAriaLabel = _i18n.i18n.translate('xpack.lens.table.tableCellFilter.filterOutValueAriaLabel', {
          defaultMessage: 'Filter out value: {cellContent}',
          values: {
            cellContent
          }
        });
        return contentsIsDefined && /*#__PURE__*/_react.default.createElement(Component, {
          "data-test-subj": "lensDatatableFilterOut",
          "aria-label": filterOutAriaLabel,
          onClick: () => {
            handleFilterClick(field, rowValue, colIndex, rowIndex, true);
            closeCellPopover === null || closeCellPopover === void 0 ? void 0 : closeCellPopover();
          },
          iconType: "minusInCircle"
        }, filterOutText);
      });
    }

    // Add all the column compatible cell actions
    const compatibleCellActions = (_columnCellValueActio = columnCellValueActions === null || columnCellValueActions === void 0 ? void 0 : columnCellValueActions[colIndex]) !== null && _columnCellValueActio !== void 0 ? _columnCellValueActio : [];
    compatibleCellActions.forEach(action => {
      cellActions.push(({
        rowIndex,
        columnId,
        Component
      }) => {
        const rowValue = table.rows[rowIndex][columnId];
        const columnMeta = columnsReverseLookup[columnId].meta;
        const data = {
          value: rowValue,
          columnMeta
        };
        return rowValue != null && /*#__PURE__*/_react.default.createElement(Component, {
          "aria-label": action.displayName,
          "data-test-subj": `lensDatatableCellAction-${action.id}`,
          onClick: () => {
            action.execute([data]);
            closeCellPopover === null || closeCellPopover === void 0 ? void 0 : closeCellPopover();
          },
          iconType: action.iconType
        }, action.displayName);
      });
    });
    const isTransposed = Boolean(columnArgs === null || columnArgs === void 0 ? void 0 : columnArgs.originalColumnId);
    const initialWidth = columnArgs === null || columnArgs === void 0 ? void 0 : columnArgs.width;
    const isHidden = columnArgs === null || columnArgs === void 0 ? void 0 : columnArgs.hidden;
    const originalColumnId = columnArgs === null || columnArgs === void 0 ? void 0 : columnArgs.originalColumnId;
    const additionalActions = [];
    additionalActions.push({
      color: 'text',
      size: 'xs',
      onClick: () => onColumnResize({
        columnId: originalColumnId || field,
        width: undefined
      }),
      iconType: 'empty',
      label: _i18n.i18n.translate('xpack.lens.table.resize.reset', {
        defaultMessage: 'Reset width'
      }),
      'data-test-subj': 'lensDatatableResetWidth',
      isDisabled: initialWidth == null
    });
    if (!isTransposed && onColumnHide) {
      additionalActions.push({
        color: 'text',
        size: 'xs',
        onClick: () => onColumnHide({
          columnId: originalColumnId || field
        }),
        iconType: 'eyeClosed',
        label: _i18n.i18n.translate('xpack.lens.table.hide.hideLabel', {
          defaultMessage: 'Hide'
        }),
        'data-test-subj': 'lensDatatableHide',
        isDisabled: !isHidden && visibleColumns.length <= 1
      });
    }
    if (!isReadOnly) {
      if (isTransposed && columnArgs !== null && columnArgs !== void 0 && columnArgs.bucketValues && handleTransposedColumnClick) {
        const bucketValues = columnArgs === null || columnArgs === void 0 ? void 0 : columnArgs.bucketValues;
        additionalActions.push({
          color: 'text',
          size: 'xs',
          onClick: () => handleTransposedColumnClick(bucketValues, false),
          iconType: 'plusInCircle',
          label: _i18n.i18n.translate('xpack.lens.table.columnFilter.filterForValueText', {
            defaultMessage: 'Filter for column'
          }),
          'data-test-subj': 'lensDatatableHide'
        });
        additionalActions.push({
          color: 'text',
          size: 'xs',
          onClick: () => handleTransposedColumnClick(bucketValues, true),
          iconType: 'minusInCircle',
          label: _i18n.i18n.translate('xpack.lens.table.columnFilter.filterOutValueText', {
            defaultMessage: 'Filter out column'
          }),
          'data-test-subj': 'lensDatatableHide'
        });
      }
    }
    const currentAlignment = alignments && alignments[field];
    const hasMultipleRows = headerRowHeight === 'auto' || headerRowHeight === 'custom';
    const columnStyle = (0, _react2.css)({
      ...(headerRowHeight === 'custom' && {
        WebkitLineClamp: headerRowLines
      }),
      ...(hasMultipleRows && {
        whiteSpace: 'normal',
        display: '-webkit-box',
        WebkitBoxOrient: 'vertical'
      }),
      textAlign: currentAlignment
    });
    const columnDefinition = {
      id: field,
      cellActions,
      visibleCellActions: 5,
      display: /*#__PURE__*/_react.default.createElement("div", {
        css: columnStyle
      }, name),
      displayAsText: name,
      actions: {
        showHide: false,
        showMoveLeft: false,
        showMoveRight: false,
        showSortAsc: {
          label: _i18n.i18n.translate('xpack.lens.table.sort.ascLabel', {
            defaultMessage: 'Sort ascending'
          })
        },
        showSortDesc: {
          label: _i18n.i18n.translate('xpack.lens.table.sort.descLabel', {
            defaultMessage: 'Sort descending'
          })
        },
        additional: additionalActions
      }
    };
    if (initialWidth) {
      columnDefinition.initialWidth = initialWidth;
    }
    return columnDefinition;
  });
};
exports.createGridColumns = createGridColumns;