"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizeFieldAction = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visualizeFieldAction = application => (0, _public.createAction)({
  type: _public.ACTION_VISUALIZE_LENS_FIELD,
  id: _public.ACTION_VISUALIZE_LENS_FIELD,
  getDisplayName: () => _i18n.i18n.translate('xpack.lens.discover.visualizeFieldLegend', {
    defaultMessage: 'Visualize field'
  }),
  isCompatible: async () => !!application.capabilities.visualize.show,
  execute: async context => {
    application.navigateToApp('lens', {
      state: {
        type: _public.ACTION_VISUALIZE_LENS_FIELD,
        payload: context
      }
    });
  }
});
exports.visualizeFieldAction = visualizeFieldAction;