"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.optimizingMiddleware = void 0;
var _lodash = require("lodash");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** cancels updates to the store that don't change the state */
const optimizingMiddleware = () => store => {
  return next => action => {
    if (_.onActiveDataChange.match(action)) {
      if ((0, _lodash.isEqual)(store.getState().lens.activeData, action.payload)) {
        return;
      }
    }
    next(action);
  };
};
exports.optimizingMiddleware = optimizingMiddleware;