"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initMiddleware = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _ = require("..");
var _load_initial = require("./load_initial");
var _settings_storage = require("../../settings_storage");
var _workspace_panel_wrapper = require("../../editor_frame_service/editor_frame/workspace_panel/workspace_panel_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const autoApplyDisabled = () => {
  return (0, _settings_storage.readFromStorage)(new _public.Storage(localStorage), _workspace_panel_wrapper.AUTO_APPLY_DISABLED_STORAGE_KEY) === 'true';
};
const initMiddleware = storeDeps => store => {
  return next => action => {
    if (_.loadInitial.match(action)) {
      return (0, _load_initial.loadInitial)(store, storeDeps, action.payload, autoApplyDisabled());
    }
    next(action);
  };
};
exports.initMiddleware = initMiddleware;