"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryInput = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _debounced_value = require("../debounced_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryInput = ({
  value,
  onChange,
  indexPattern,
  isInvalid,
  onSubmit,
  disableAutoFocus,
  ['data-test-subj']: dataTestSubj,
  placeholder
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _debounced_value.useDebouncedValue)({
    value,
    onChange
  });
  const lensAppServices = (0, _public2.useKibana)().services;
  const {
    data,
    uiSettings,
    http,
    notifications,
    docLinks,
    storage,
    unifiedSearch,
    dataViews
  } = lensAppServices;
  return /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    dataTestSubj: dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'indexPattern-filters-queryStringInput',
    size: "s",
    disableAutoFocus: disableAutoFocus,
    isInvalid: isInvalid,
    bubbleSubmitEvent: false,
    indexPatterns: [indexPattern],
    query: inputValue,
    onChange: newQuery => {
      if (!(0, _lodash.isEqual)(newQuery, inputValue)) {
        handleInputChange(newQuery);
      }
    },
    onSubmit: () => {
      if (inputValue.query) {
        onSubmit();
      }
    },
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : inputValue.language === 'kuery' ? _i18n.i18n.translate('xpack.lens.indexPattern.filters.queryPlaceholderKql', {
      defaultMessage: '{example}',
      values: {
        example: 'method : "GET" or status : "404"'
      }
    }) : _i18n.i18n.translate('xpack.lens.indexPattern.filters.queryPlaceholderLucene', {
      defaultMessage: '{example}',
      values: {
        example: 'method:GET OR status:404'
      }
    }),
    languageSwitcherPopoverAnchorPosition: "rightDown",
    appName: _i18n.i18n.translate('xpack.lens.queryInput.appName', {
      defaultMessage: 'Lens'
    }),
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      storage,
      dataViews
    }
  });
};
exports.QueryInput = QueryInput;