"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateQuery = exports.isQueryValid = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateQuery = (input, indexPattern) => {
  let isValid = true;
  let error;
  try {
    if (input) {
      if (input.language === 'kuery') {
        (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(input.query), indexPattern);
      } else {
        (0, _esQuery.luceneStringToDsl)(input.query);
      }
    }
  } catch (e) {
    isValid = false;
    error = e.message;
  }
  return {
    isValid,
    error
  };
};
exports.validateQuery = validateQuery;
const isQueryValid = (input, indexPattern) => validateQuery(input, indexPattern).isValid;
exports.isQueryValid = isQueryValid;