"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendSizeSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualizations-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const legendSizeOptions = [{
  value: _public.LegendSize.SMALL,
  inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.small', {
    defaultMessage: 'Small'
  })
}, {
  value: _public.LegendSize.MEDIUM,
  inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.medium', {
    defaultMessage: 'Medium'
  })
}, {
  value: _public.LegendSize.LARGE,
  inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.large', {
    defaultMessage: 'Large'
  })
}, {
  value: _public.LegendSize.EXTRA_LARGE,
  inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.extraLarge', {
    defaultMessage: 'Extra large'
  })
}];
const LegendSizeSettings = ({
  legendSize,
  onLegendSizeChange,
  isVerticalLegend,
  showAutoOption
}) => {
  (0, _react.useEffect)(() => {
    if (legendSize && !isVerticalLegend) {
      onLegendSizeChange(undefined);
    }
  }, [isVerticalLegend, legendSize, onLegendSizeChange]);
  const onLegendSizeOptionChange = (0, _react.useCallback)(option => onLegendSizeChange(option === _public.DEFAULT_LEGEND_SIZE ? undefined : option), [onLegendSizeChange]);
  if (!isVerticalLegend) return null;
  const options = showAutoOption ? [{
    value: _public.LegendSize.AUTO,
    inputDisplay: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.legendSizeOptions.auto', {
      defaultMessage: 'Auto'
    })
  }, ...legendSizeOptions] : legendSizeOptions;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.legendSizeSetting.label', {
      defaultMessage: 'Legend width'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    compressed: true,
    valueOfSelected: legendSize !== null && legendSize !== void 0 ? legendSize : _public.DEFAULT_LEGEND_SIZE,
    options: options,
    onChange: onLegendSizeOptionChange
  }));
};
exports.LegendSizeSettings = LegendSizeSettings;